#! /usr/bin/python3
# Last edited on 2024-07-26 08:52:22 by stolfi

import slicing_mesh
import slicing_rackpin
import slicing_obj
import slicing_pov

import sys
import random

# The program takes three parameters from the command line: 
# 
#  {pert} the coordinate perturbation amount, in units of {2*eps}.
#  {xrot} the rotation towards the {X}-axis (degrees).
#  {yrot} the rotation towards the {Y}-axis (degrees).
#
# The object consists of a straight rack and a matching pinion.
 
prec = 4          # Decimal digits    
eps = 0.1**prec   # Coordinate quantum.

random.seed(4615)

def main():
  pert = int(sys.argv[1])          # Random perturbation amount, in {eps} units.
  xrot = int(sys.argv[2])          # Rotation in the direction of the {X}-axis (degrees).
  yrot = int(sys.argv[3])          # Rotation in the direction of the {Y}-axis (degrees).
  
  sys.stderr.write("slicing_rap_example.py: ")
  sys.stderr.write(f" pert = {pert}")
  sys.stderr.write(f" xrot = {xrot:.4f}")
  sys.stderr.write(f" yrot = {yrot:.4f}")
  sys.stderr.write("\n")
  
  assert 0 <= pert and pert < 50, "invalid pert"
  assert abs(xrot) < 90, "invalid xrot"
  assert abs(yrot) < 90, "invalid yrot"
  
  M = slicing_rackpin.build_mesh()

  rmat = slicing_mesh.tilt_matrix(xrot,yrot)
  slicing_mesh.rotate(M,rmat)
  slicing_mesh.perturb_vertices(M,pert)
  slicing_mesh.round_vertices(M,eps)

  file_prefix = f"out/rap_pa{pert:03d}_xr{xrot:03d}_yr{yrot:03d}"

  wro = open(file_prefix + "_triF.obj", 'w')
  slicing_obj.write(wro, M, False)
  wro.close()
  
  wrt = open(file_prefix + "_triT.obj", 'w')
  slicing_obj.write(wrt, M, True)
  wrt.close()

  wrp = open(file_prefix + ".inc", 'w')
  slicing_pov.write(wrp, M)
  wrp.close()

  return 0

main()

 
