#ifndef ER_TEST_H
#define ER_TEST_H

    #include <er_ECLES_least_squares.h>

    int executeTest();

    void testSolveDirect(int m, int n, double A[], int p, double B[]);
    void testSolveDirect(int m, int n, fmpz_mat_t A, int p, fmpz_mat_t B);

    void testSolve(int r, int m, int n, fmpz_mat_t U, fmpz_mat_t L, fmpz_mat_t D, int Pr[], int Pc[], double A[], int p, double B[]);
    void testSolve(int r, int m, int n, fmpz_mat_t U, fmpz_mat_t L, fmpz_mat_t D, int Pr[], int Pc[], fmpz_mat_t A, int p, fmpz_mat_t B);

    void testSolveLS(int r, int m, int n, fmpz_mat_t U, fmpz_mat_t L, fmpz_mat_t D, int Pr[], int Pc[], double A[], int p, double B[]);
    void testSolveLS(int r, int m, int n, fmpz_mat_t U, fmpz_mat_t L, fmpz_mat_t D, int Pr[], int Pc[], fmpz_mat_t A, int p, fmpz_mat_t B);

    void testSolveLSDirect(int r, int m, int n, fmpz_mat_t U, fmpz_mat_t L, fmpz_mat_t D, int Pr[], int Pc[], double A[], int p, double B[]);
    void testSolveLSDirect(int r, int m, int n, fmpz_mat_t U, fmpz_mat_t L, fmpz_mat_t D, int Pr[], int Pc[], fmpz_mat_t A, int p, fmpz_mat_t B);

    void testInverse(int r, int m, int n, fmpz_mat_t U, fmpz_mat_t L, fmpz_mat_t D, int Pr[], int Pc[], double A[]);

    void testLU(int m, int n, int r, int Pr[], int Pc[], fmpz_mat_t U, fmpz_mat_t L, fmpz_mat_t D, double A[]);
    void testLU(int m, int n, int r, int Pr[], int Pc[], fmpz_mat_t U, fmpz_mat_t L, fmpz_mat_t D, fmpz_mat_t A);


#endif // ER_TEST_H
