// Test of single slider
// Last edited on 2002-03-25 01:52:35 by stolfi

#include "background.inc"
#include "fgstyle-1.inc"     // classic: chocolate wood, dkwine/dkblue sliders

#declare show_cut = 1;  // 1 to show a cutaway view
#declare show_rod = 1;  // 1 to show the rod 

#include "dcc-view-6.inc"    // from bottom left, closer
#include "dcc-lights-8.inc"  // from front and top right, highlight

#include "dcc-std-abacus.inc"

#if (show_cut)
  intersection{
    object{
      abacus_slider
      texture{abacus_unit_slider_texture}
    }
    plane {
      <1,0,0>, 0
      texture{abacus_unit_slider_texture}
    }
  }
#else
  object{
    abacus_slider
    texture{abacus_unit_slider_texture}
  }
#end

#if (show_rod)
  object{
    abacus_stick
    rotate <0,0,-90>
    scale 1/abacus_slider_scale
  }
#end

#declare baseHY = 0.10;
#declare baseY = - (1.5 * abacus_slider_HY);
#declare baseR = 1.5;

cylinder {
  <0.0, baseY-baseHY, 0.0>,
  <0.0, baseY+baseHY, 0.0>,
  baseR
  texture{
    pigment {color rgb <1.00, 1.00, 1.00>}
    finish {diffuse 0.95 ambient 0.05}
  }
}

