/*
  A wood texture originally developed for the Escola 96 logo
  Last edited on 2002-03-29 12:28:47 by stolfi

  Requires
  
    color_wood_lite
    color_wood_dark
  
  Defines
  
    color_wood_mean
    texture_wood
    
*/

#declare color_wood_mean = (color_wood_lite + color_wood_dark)/2; 

#declare texture_wood =
  texture{
    pigment{
      wood
      turbulence 0.2
      color_map{ 
        [ 0.0, 0.6  
          color rgb color_wood_lite
          color rgb color_wood_lite
        ]
        [ 0.6, 0.8  
          color rgb color_wood_lite
          color rgb color_wood_dark
        ]
        [ 0.8, 1.01 
          color rgb color_wood_dark
          color rgb color_wood_dark
        ]
      }
      scale <3.00, 0.06, 0.06>
    }
    normal{
      wrinkles 0.2
      scale <3.00, 0.06, 0.06>
    }
    finish {diffuse 0.9 ambient 0.1}
  }
  texture{
    pigment{color rgb <1.00, 1.00, 1.00> filter 0.80}
    normal{
      wrinkles 0.2
      scale <3.00, 0.06, 0.06>
    }
    finish {diffuse 0.0 ambient 0.0 specular 0.4 roughness 0.02}
  }
  
