// POVRAY description of the DCC "abacus" logo, fancy colors
// Last edited on 2003-09-15 20:26:13 by stolfi

#include "background.inc"
#include "fgstyle-special.inc"
#include "dcc-lights-0.inc"
#include "dcc-view-0.inc"

#declare show_disk = 0;  // 1 to show the marble disk
#declare show_wall = 1;  // 1 to show the background plane (colored bgColor)

#declare abacus_bottom_Y = 0.0;
#declare base_top_Y      = -0.1;
#include "dcc-std-abacus.inc"

#declare abacus_Y_shift = abacus_bottom_Y + abacus_frame_thickness/2;

object{abacus 
  rotate <0,90,0> 
  translate <0.0, abacus_Y_shift, 0.0> 
}

// #include "test-balls-abacus.inc"
// object{ test_balls_abacus }

#declare highlight_color = color rgb <1.00, 1.00, 1.00>;

#if (show_wall)
  // The plain plane

  #declare matte_color = color bgColor;
  #include "textures/matte.inc"
  #declare base_texture = texture { texture_matte }

  #include "dcc-base-plane.inc"
#end

#if (show_disk)
  // The marble disk:

  #include "dcc-marbles.inc"

  #declare base_texture = texture{texture_marble_pink}

  #declare base_disk_thickness = 0.20;
  #declare base_disk_radius = 1.5;
  #include "dcc-base-disk.inc"
#end

#if (show_disk | show_wall)
  #declare base_shift_Y = base_top_Y;
  object{ abacus_base translate < 0.0, base_shift_Y, 0.0 > }
#end
