// Last edited on 2024-05-28 07:24:01 by stolfi
// Some texture tools.

#macro texture_matte(clr) 
  // Flat matte texture.
  texture{
    pigment{ color rgb clr }
    finish{ diffuse 0.900 ambient 0.100 }
  }
#end

#macro texture_matte_ambient(clr, amb) 
  // Flat matte texture with high "ambient" component.
  texture{
    pigment{ color rgb clr }
    finish{ diffuse 1-amb ambient amb }
  }
#end

#macro texture_plastic(clr) 
  // Plastic texture with diffuse color {clr}.
  texture{
    pigment{ color rgb clr }
    finish { diffuse 0.900 ambient 0.100 specular 0.300 roughness 0.01 }
  }
#end

#macro texture_subtle(clr)
  // Glass-like surface to show bounding boxes and such.
  texture{
    pigment{ color rgb 0.850*<1,1,1> + 0.150*clr filter 0.800 }
    finish{ diffuse 0.120 reflection 0.000 ambient 0.050 specular 0.250 roughness 0.005 }
  }
#end

#macro texture_less_subtle(clr,flt)
  // More opaque glass-like surface to show bounding boxes and such.
  texture{
    pigment{ color rgb clr filter flt }
    finish{ diffuse 0.20*(1-flt) reflection 0.000 ambient 0.80*(1-flt) specular 0.010 roughness 0.005 }
  }
#end

#macro texture_epoxy(clr)
  // Semi-matte epoxy paint texture.
  texture{ 
    pigment{ color rgb clr }
    finish{ diffuse 0.900 reflection 0.000 ambient 0.050 specular 0.250 roughness 0.020 }
  }
#end

#macro texture_cutaway(clr)
  // Texture for cutaway surfaces.
  texture{
    pigment{ color rgb clr }
    finish{ diffuse 0.600 ambient 0.300 specular 0.500 roughness 0.005 }
  }
#end

#macro texture_lamp(clr)
  // Texture that is almost insensitive to lighting.
  texture{
    pigment{ color rgb clr }
    finish{ diffuse 0.100 ambient 0.900 specular 0.100 roughness 0.005 }
  }
#end

#macro texture_brushed_metal(clr)
  // Brushed metal surface.
  texture{ 
    pigment{ color rgb clr }
    finish{ diffuse 0.850 ambient 0.010 specular 0.600 roughness 0.100 }
  }
#end

#macro texture_mirror(clr)
  // Colored mirror surface.
  texture{
    pigment{ color rgb clr }
    finish{ diffuse 0.200 reflection 0.700*clr ambient 0.100 }
  }
#end

#macro texture_transparent(clr, filt)
  // Use with index of refraction near 1 for plastic, higher for glass
  #local opaq = (1-filt)/0.300;

  texture{
    pigment{ color rgb clr filter filt }
    finish{ diffuse opaq*0.030 ambient opaq*0.020 reflection opaq*0.250 specular 0.250 roughness 0.005 }
  }
#end

#macro texture_invisible()
  // Totally transparent with no reflection.
  texture{
    pigment{ color rgb < 1.000, 1.000, 1.000 > filter 1.000 }
    finish{ diffuse 0.000 reflection 0.000 ambient 0.000 specular 0.000 }
  }
#end

#macro texture_tiles(clrA, clrB, sz)
  // Floor tiles of size {sz}:
  texture{
    pigment{ checker color rgb clrA, color rgb clrB }
    finish{ diffuse 0.900 ambient 0.100 }
    scale sz
  }
#end

#macro texture_tiles_subtle(clrA, clrB, sz)
  // Translucent floor tiles of size {sz}:
  texture{
    pigment{ checker
      color rgb 0.850*<1,1,1> + 0.150*clrA filter 0.800, 
      color rgb 0.850*<1,1,1> + 0.150*clrB filter 0.800
    }
    finish{ diffuse 0.170 ambient 0.100 specular 0.250 roughness 0.005 }
    scale sz
  }
#end

#macro texture_wood(clrA, clrB, tur)
  // Wood texture with color varying from {clrA} to {clrB}
  // and the specified amount of turbulence {tur}.
  #local clrM = 0.5*(clrA + clrB);
  texture{
    pigment{
      wood
      ramp_wave
      color_map{
        [ 0.0 0.7 color rgb clrA color rgb clrM ]
        [ 0.7 0.9 color rgb clrM color rgb clrB ]
        [ 0.9 1.0 color rgb clrB color rgb clrA ]
      }
      warp{ turbulence tur }
      scale 3*< 5, 5, 30 >
    }
    finish{ diffuse 0.8 ambient 0.1 specular 0.1 roughness 0.02 }
  }
#end
