
def profile(N,nr,ni,nt,th,alpha):
  # Profile of a tooth of a gear with {N} teeth, pitch {th},
  # and pressure angle {alpha}.
  #
  # Returns a list of vertices {vp} of an open polygonal line that is the 
  # profile of one tooth. Each vertex is a quadruple {(x,y,z,lab)}
  # where {x,y,z} are vertex coordinates and {lab} is a string that
  # describes the vertex.
  #
  # The profile lies on the plane {Z=0} and is symmetric about the 
  # {Y} axis, with the datum line going through the origin.
  #
  # The tooth profile consists of six sections: two root shoulders, two involute segments,
  # and two tip shoulders. Each shoulder approximates an arc of circle.
  # There is an edge between every two consecutive sections, and 
  # between the root shoulders of consecutive teeth.
  #
  # The profile is specific for a circular gear with {nt} teeth.
  # If {nt} is infinite, a rack tooth is generated, with flat 
  # involute section.  In that case the {ni} may well be zero.
  #
  # The label of each vertex is "{u}.{j:04d}" where {u} is 
  # 'r0', 'i0', 't0', 't1', 'i1', 'r1' in sequence along the 
  # profile, and {j} is a vertex index within the section.
  # This index ranges in {0..nr}, {0..ni}, {0..nt}. 
  # The {X} coordinate is generally increasing with {j} in the sections
  # 'r0', 't1' and decreasing in sections 't0' and 'r1'.
  # The {Y} coordinate is generally increasing with {j}
  # in both sections 'i0' and 'i1'.
  return slicing_tooth_IMP.profile(N,nr,ni,nt,th,alpha) 
