/*
  A wood texture originally developed for the Escola 96 logo
  
  Defines
  
    lite_wood_color
    dark_wood-color
    
    wood_texture
    
*/

#declare lite_wood_color = color rgb < 0.70, 0.32, 0.14 >;
#declare dark_wood_color = color rgb < 0.20, 0.02, 0.01 >;

#declare wood_texture =
  texture{
    pigment{
      wood
      turbulence 0.2
      color_map{ 
        [ 0.0, 0.6  
          color lite_wood_color
          color lite_wood_color
        ]
        [ 0.6, 0.8  
          color lite_wood_color
          color dark_wood_color
        ]
        [ 0.8, 1.01 
          color dark_wood_color
          color dark_wood_color
        ]
      }
      scale <3.00, 0.06, 0.06>
    }
    normal{
      wrinkles 0.2
      scale <3.00, 0.06, 0.06>
    }
    finish {diffuse 0.95 ambient 0.05}
  }
  texture{
    pigment{color rgb <1.00, 1.00, 1.00> filter 0.80}
    normal{
      wrinkles 0.2
      scale <3.00, 0.06, 0.06>
    }
    finish {diffuse 0.0 ambient 0.0 specular 0.4 roughness 0.01}
  }
  
