// Windows on the right wall (for specular surfaces)

// Requires
//
//   window_width
//   window_height
//   window_dist
//   window_min_Y
//   window_min_Z
//
//   window_texture
//
// Defines
//
//   dcc_windows_right

#declare window_pane = box{ <0,0,0>, <1,1,1> }

#declare dcc_windows_right =
  union{
    object{ window_pane translate < 0.00, 0.00, 0.00 > }
    object{ window_pane translate < 0.00, 1.10, 0.00 > }
    object{ window_pane translate < 0.00, 2.20, 0.00 > }
    object{ window_pane translate < 0.00, 0.00, 1.10 > }
    object{ window_pane translate < 0.00, 1.10, 1.10 > }
    object{ window_pane translate < 0.00, 2.20, 1.10 > }
    object{ window_pane translate < 0.00, 0.00, 2.20 > }
    object{ window_pane translate < 0.00, 1.10, 2.20 > }
    object{ window_pane translate < 0.00, 2.20, 2.20 > }
    texture{ window_texture }
    scale < 0.001, window_width/3.20, window_height/3.20 >
    translate < window_dist, window_min_Y, window_min_Z >
  }
