/*
  A wood texture originally developed for the Escola 96 logo
  Last edited on 2002-03-31 22:35:11 by stolfi
  Polished wood finish

  Requires

    color_wood_lite
    color_wood_dark

  Defines

    color_wood_mean
    texture_wood

*/

#declare color_wood_mean = (color_wood_lite + color_wood_dark)/2; 

#declare texture_wood_stretch = <3.00, 0.06, 0.06>;

#declare texture_wood_lite_dull =
  texture{
    pigment{ color rgb color_wood_lite }
    normal{ 
      granite 0.05 
      slope_map{
        [ 0.00 < 1.00, 00.00 > ]
        [ 0.70 < 1.00, 00.00 > ]
        [ 0.70 < 1.00, -2.00 > ]
        [ 1.00 < 0.00, 00.00 > ]
      }
      scale < 4.00, 0.04, 0.04 >/texture_wood_stretch
    }
    finish { diffuse 0.95 ambient 0.05 specular 0.2 roughness 0.003 }
  }

#declare texture_wood_dark_shin =
  texture{
    pigment{ color rgb color_wood_dark }
    normal{ 
      granite 0.03 
      slope_map{
        [ 0.00 < 1.00, 00.00 > ]
        [ 0.60 < 1.00, 00.00 > ]
        [ 0.60 < 1.00, -2.00 > ]
        [ 1.00 < 0.00, 00.00 > ]
      }
      scale < 4.00, 0.04, 0.04 >/texture_wood_stretch
    }
    finish { diffuse 0.95 ambient 0.05 specular 0.6 roughness 0.003 }
  }

#declare texture_wood =
  texture{
    wood
    turbulence 0.2
    texture_map{ 
      [ 0.6 texture_wood_lite_dull ]
      [ 0.8 texture_wood_dark_shin ]
    }
    scale texture_wood_stretch
  }
