#declare fan_outer_chain_even_radius = 100.0000;

#declare fan_outer_chain_odd_radius = 95.0368;

#declare fan_inner_chain_even_radius = 0.0000;

#declare fan_inner_chain_odd_radius = 0.0000;

#declare fan_thickness = 9.9996;

#declare fan_min_elevation = 20.00000; // Degrees.

#declare fan_max_elevation = 70.00000; // Degrees.

#declare fan_num_faces = 10;

#declare fan_num_edges = 24;

#declare fan_num_vertices = 16;

#declare fan_num_outer_chain_edges = 6;

#declare fan_num_inner_chain_edges = 0;

#declare fan_outer_chain_shape = 1;

#macro fan_vertices()
  #local Nv = fan_num_vertices;
  // Returns an array {V} of {Nv+1} elements.
  // Element {V[kv]} is the vertex with OBJ index {kv} in {1..Nv}.
  // Element {V[0]} is not used.
  #local V = array[Nv+1]
  #local V[   0] = < -1, -1, -1>; // Not used.
  #local V[   1] = < 4.9998, 93.9692, 34.2020 >; // vo.0.0
  #local V[   2] = < 4.9998, 83.6516, 45.1046 >; // vo.0.1
  #local V[   3] = < 4.9998, 80.2124, 59.7158 >; // vo.0.2
  #local V[   4] = < 4.9998, 67.2012, 67.2012 >; // vo.0.3
  #local V[   5] = < 4.9998, 59.7158, 80.2124 >; // vo.0.4
  #local V[   6] = < 4.9998, 45.1046, 83.6516 >; // vo.0.5
  #local V[   7] = < 4.9998, 34.2020, 93.9692 >; // vo.0.6
  #local V[   8] = < 4.9998, 0.0000, 0.0000 >; // vi.0.0
  #local V[   9] = < -4.9998, 93.9692, 34.2020 >; // vo.1.0
  #local V[  10] = < -4.9998, 83.6516, 45.1046 >; // vo.1.1
  #local V[  11] = < -4.9998, 80.2124, 59.7158 >; // vo.1.2
  #local V[  12] = < -4.9998, 67.2012, 67.2012 >; // vo.1.3
  #local V[  13] = < -4.9998, 59.7158, 80.2124 >; // vo.1.4
  #local V[  14] = < -4.9998, 45.1046, 83.6516 >; // vo.1.5
  #local V[  15] = < -4.9998, 34.2020, 93.9692 >; // vo.1.6
  #local V[  16] = < -4.9998, 0.0000, 0.0000 >; // vi.1.0
  V
#end

#macro fan_edges()
  #local Ne = fan_num_edges;
  // Returns an array {E} of {Ne+1} elements.
  // Element {E[ke]} is the triple {<ko[ke],kd[ke],ty[ke]>}, for {ke} in {1..Ne}.
  // Here {ko[ke],kd[ke]} are the indices of the vertices
  // which are the endpoints of edge {E[ke]},
  // and {ty[ke]} is an edge type code:
  // 
  //   100-199 outer chain edge of plaza [0].
  //   200-299 inner chain edge of plaza [0].
  //   300-399 outer chain edge of plaza [1].
  //   400-499 inner chain edge of plaza [1].
  //   0       other.
  // 
  // The index of the edge in the chain is {ty[ke] % 100}.
  #local E = array[Ne+1]
  #local E[   0] = < -1, -1, -1 >; // Not used.
  #local E[   1] = < 1, 9, 0 >;
  #local E[   2] = < 9, 10, 300 >;
  #local E[   3] = < 2, 10, 0 >;
  #local E[   4] = < 10, 11, 301 >;
  #local E[   5] = < 3, 11, 0 >;
  #local E[   6] = < 11, 12, 302 >;
  #local E[   7] = < 4, 12, 0 >;
  #local E[   8] = < 12, 13, 303 >;
  #local E[   9] = < 5, 13, 0 >;
  #local E[  10] = < 13, 14, 304 >;
  #local E[  11] = < 6, 14, 0 >;
  #local E[  12] = < 14, 15, 305 >;
  #local E[  13] = < 8, 16, 0 >;
  #local E[  14] = < 1, 8, 0 >;
  #local E[  15] = < 7, 15, 0 >;
  #local E[  16] = < 15, 16, 0 >;
  #local E[  17] = < 1, 2, 100 >;
  #local E[  18] = < 2, 3, 101 >;
  #local E[  19] = < 3, 4, 102 >;
  #local E[  20] = < 4, 5, 103 >;
  #local E[  21] = < 5, 6, 104 >;
  #local E[  22] = < 6, 7, 105 >;
  #local E[  23] = < 7, 8, 0 >;
  #local E[  24] = < 9, 16, 0 >;
  E
#end

#macro fan_faces()
  #local Nf = fan_num_faces;
  // Returns an array {F} of {Nf+1} elements.
  // Element {F[kf]} is an instance of the
  // 'plane' (halfspace) POV-ray primitive
  // for {kf} in {1..Nf}.
  // The order is outer chain faces, inner chain faces.
  // inner-outer connecting faces,
  // and finally the plazas.
  #local F = array[Nf+1]
  #local F[   0] = sphere{ <0,0,0>, 1000} // Not used.
  #local F[   1] = plane{  < 0.0000000, 0.7263178, 0.6873591 >, 0 translate < 4.9998, 93.9693, 34.2020 > }
  #local F[   2] = plane{  < 0.0000000, 0.9733983, 0.2291197 >, 0 translate < 4.9998, 83.6516, 45.1045 > }
  #local F[   3] = plane{  < 0.0000000, 0.4986680, 0.8667931 >, 0 translate < 4.9998, 80.2123, 59.7159 > }
  #local F[   4] = plane{  < 0.0000000, 0.8667931, 0.4986680 >, 0 translate < 4.9998, 67.2012, 67.2012 > }
  #local F[   5] = plane{  < 0.0000000, 0.2291197, 0.9733983 >, 0 translate < 4.9998, 59.7159, 80.2123 > }
  #local F[   6] = plane{  < 0.0000000, 0.6873591, 0.7263178 >, 0 translate < 4.9998, 45.1045, 83.6516 > }
  #local F[   7] = plane{  < 0.0000000, 0.3420201, -0.9396926 >, 0 translate < 4.9998, 0.0000, 0.0000 > }
  #local F[   8] = plane{  < 0.0000000, -0.9396926, 0.3420201 >, 0 translate < 4.9998, 34.2020, 93.9693 > }
  #local F[   9] = plane{  < 1.0000000, 0.0000000, 0.0000000 >, 0 translate < 4.9998, 0.0000, 0.0000 > }
  #local F[  10] = plane{  < -1.0000000, 0.0000000, 0.0000000 >, 0 translate < -4.9998, 0.0000, 0.0000 > }
  F
#end

