// Last edited on 2024-05-30 11:35:18 by stolfi

#macro nut_solid(F, Nr, Ro, Ri, Ha, subfig)
  // The 3D volume of the nut.  Parameters:
  
  // {F}      Array of planes that define the faces, {F[1..Nf]}.
  // {Nr}     Number of sides of the nut's outer wall and hole.
  // {Ro}     Circumradius of the nut.
  // {Ri}     Circumradius of the hole.
  // {Ha}     Height of the nut.
  // {subfig} Which sub-figure we are generating.

  #debug "!! Generating the object's surface ...\n"

  #local Nf = dimension_size(F, 1) - 1;

  // Bounding cylinder for the whole nut:
  #local ocyl = cylinder{ <0,0,-0.55*Ha>, <0,0,+0.55*Ha>, 1.1*Ro }

  // Bounding cylinder for the hole:
  #local icyl = cylinder{ <0,0,-0.60*Ha>, <0,0,+0.60*Ha>, 1.1*Ri }

  // The body of the nut without the hole:
  #local filled_nut = 
    intersection{
      object{ ocyl }
      #for (kf, 1, Nf-Nr)
        object{ F[kf] }
      #end
    }

  //The hole driller:
  #local hole = 
    difference{
      object{ icyl }
      #for (kf, Nf-Nr+1, Nf)
        object{ F[kf] }
      #end
    }

  // The nut with hole:
  #local drilled_nut = 
    difference{ 
      object{ filled_nut }
      object{ hole }
    }
    
  #if ((subfig >= 0) & (subfig <= 7))
    #local surf = object{ drilled_nut texture { nut_tx_face } }
  #else
    // Object's surface is invisible, but still present to preserve the bounding box:
    #local cutter = plane{ z,0 }
    #local surf = 
      union{
        intersection{ 
          object{ drilled_nut texture{ nut_tx_invisible } }
          object{ cutter texture{ nut_tx_slice } }
        }
        difference{
          object{ drilled_nut } 
          object{ cutter translate 0.001*z }
          texture{ nut_tx_invisible }
        }
      }
  #end

  surf
#end