//  Arquivo:
//  Interface.java
//
//  Objetivo:
//  Implementar a interface principal do projeto usando o layout
//  de interface definido pela classe InterfaceLayout.class, que
//  dispe de um mtodo para posicionar os componentes em coordenadas
//  espefcas na tela
//  
//  Compilador: javac 1.3
//  Autor: Fbio Dalla Vecchia - RA:981091
//  ltima Atualizao: 15-Jun-2001  
// 

import java.awt.*;
import java.applet.Applet;

// importa a classe de Layout personalizado
import InterfaceLayout;

// importa as classes de canvas usadas para cada componente
import CanvasMapaReduzido;
import CanvasBotaoZoomIn;
import CanvasBotaoZoomOut;
import CanvasBotaoImprimir;
import CanvasBotaoMelhorCaminho;
import CanvasBotaoArquivoVeiculo;
import CanvasBotaoArquivoEncomenda;
import CanvasMapaCalculado;

// Classe: Interface
// Autor: Fbio Dalla Vecchia - RA:981091
public class Interface extends Applet {
    
    // Definicao das String
    String TituloApplet = "Easy Router - Prottipo Interface - (Fbio Vecchia)";
    
    // Declarao dos rtulos do Applet
    Label LabelTitulo;            // ttulo
    Label LabelSelecVeiculo;      // seleo do veculo desejado
    Label LabelSelecEncomenda;    // seleo da encomenda desejada
    
    // Declarao das Caixas de Seleo de Veculos/Encomendas
    Choice BoxVeiculos; 
    Choice BoxEncomendas;
    
    // Declarao das Imagens
    Image ImagemMapaReduzido;
    Image ImagemMapaCalculado;
    Image ImagemBotaoZoomIn[];  
    Image ImagemBotaoZoomOut[]; 
    Image ImagemBotaoImprimir[];
    Image ImagemBotaoMelhorCaminho[];
    Image ImagemBotaoArquivoVeiculo[]; 
    Image ImagemBotaoArquivoEncomenda[]; 

    TextField TxtVeiculos;
    TextField TxtEncomendas;
    String ArquivoVeiculo;    // Arquivo de Veculos
    String ArquivoEncomenda;  // Arquivo de Encomendas

    Font FonteTitulo;         // Fonte usada em alguns textos do applet         

    // Declarao dos controles do Applet (cada um em seu prprio
    // canvas, com controles personalizados)
    CanvasBotaoZoomIn BotaoZoomIn;
    CanvasBotaoZoomOut BotaoZoomOut;
    CanvasBotaoImprimir BotaoImprimir;
    CanvasBotaoMelhorCaminho BotaoMelhorCaminho;
    CanvasBotaoArquivoVeiculo BotaoArquivoVeiculo;
    CanvasBotaoArquivoEncomenda BotaoArquivoEncomenda;
    CanvasMapaReduzido MapaReduzido;
    CanvasMapaCalculado MapaCalculado;
 
    // Inicializao das estruturas do Applet
    public void init() {

        InicializaVeiculo();
        InicializaEncomenda();
        AlocaBufferImagens();
        CarregaImagens();
        InicializaRotulos();

        // Setamos o Layout personalizado a ser usado no applet
        setLayout( new InterfaceLayout() );
        
        InicializaRotulos();
        InicializaCanvas();
        AdicionaComponentes();
        PosicionaComponentes();

        // OBS: Abrir "FileDialog" em Browsers  proibido (por motivos
        // de seguranca do Java). Portanto, para este Applet rodar 
        // num Browser comum, essas 2 rotinas abaixo devem ser 
        // alteradas...
        EscolherArquivoVeiculo();
        EscolherArquivoEncomenda();       
        }

    // mtodo start() do Applet
    public void start() {
        repaint();
        

        }

    // mtodo stop() do Applet
    public void stop(){
        }

    public void update(Graphics g) {
    	
    	// Exibe mensagens de controle na linha de status do AppletViewer/Browser
        if (MapaReduzido.msgStatus) showStatus(MapaReduzido.msg);
        if (BotaoZoomIn.msgStatus || BotaoZoomIn.BotaoPressionado) showStatus(BotaoZoomIn.msg);
        if (BotaoZoomOut.msgStatus || BotaoZoomOut.BotaoPressionado) showStatus(BotaoZoomOut.msg);
        if (MapaCalculado.msgStatus) showStatus(MapaCalculado.msg);
        if (BotaoImprimir.msgStatus) showStatus(BotaoImprimir.msg);
        if (BotaoMelhorCaminho.msgStatus || BotaoMelhorCaminho.BotaoPressionado) showStatus(BotaoMelhorCaminho.msg);
        if (BotaoArquivoVeiculo.msgStatus|| BotaoArquivoVeiculo.BotaoPressionado) showStatus(BotaoArquivoVeiculo.msg);
        if (BotaoArquivoEncomenda.msgStatus || BotaoArquivoEncomenda.BotaoPressionado) showStatus(BotaoArquivoEncomenda.msg);
     	// Opcao de impressao do Mapa Calculado
     	if (BotaoImprimir.BotaoPressionado) {
     		showStatus("Imprimindo...");
     		print(g);
     	}	
     	paint (g);
        }

    public void paint (Graphics g) {
    	repaint();
    	} 

///////////////////////////////
// Mtodos de inicializacao
///////////////////////////////

    // Mtodo para alocar buffer para as imagens de /maps e /icons
    public void AlocaBufferImagens() {
        // Inicializacao das Imagens
       
        mensagem("Alocando Buffer para Imagens...");
        ImagemBotaoZoomIn   = new Image[2];
        ImagemBotaoZoomOut  = new Image[2];
        ImagemBotaoImprimir = new Image[2];
        ImagemBotaoMelhorCaminho = new Image[2];
        ImagemBotaoArquivoVeiculo = new Image[2];
        ImagemBotaoArquivoEncomenda = new Image[2];    	
    	}

    // Mtodo para carregar as imagens usadas na Interface
    public void CarregaImagens() {
       
        // Carregamento das imagens dos componentes do Applet 
        mensagem("Carregando Imagens...");
         
        ImagemBotaoZoomIn[0] = getImage( getCodeBase(),"./icons/zoom+01.gif" );
        ImagemBotaoZoomIn[1] = getImage( getCodeBase(),"./icons/zoom+02.gif" );

        ImagemBotaoZoomOut[0] = getImage( getCodeBase(),"./icons/zoom-01.gif" );
        ImagemBotaoZoomOut[1] = getImage( getCodeBase(),"./icons/zoom-02.gif" );
                
        ImagemBotaoImprimir[0] = getImage( getCodeBase(),"./icons/printr01.gif" );
        ImagemBotaoImprimir[1] = getImage( getCodeBase(),"./icons/printr02.gif" );

        ImagemBotaoMelhorCaminho[0] = getImage( getCodeBase(),"./icons/melhcamin01.gif" );
        ImagemBotaoMelhorCaminho[1] = getImage( getCodeBase(),"./icons/melhcamin02.gif" );

        ImagemBotaoArquivoVeiculo[0] = getImage( getCodeBase(),"./icons/veiculo01.gif" );
        ImagemBotaoArquivoVeiculo[1] = getImage( getCodeBase(),"./icons/veiculo02.gif" );

        ImagemBotaoArquivoEncomenda[0] = getImage( getCodeBase(),"./icons/encomenda01.gif" );
        ImagemBotaoArquivoEncomenda[1] = getImage( getCodeBase(),"./icons/encomenda02.gif" );

        ImagemMapaReduzido = getImage( getDocumentBase(),"./maps/big-thumb.jpg" );
        ImagemMapaCalculado= getImage( getDocumentBase(),"./maps/modelo-mapa.jpg" );
    	
        }

    // Mtodo para inicializar a caixa de seleo dos Veculos 
    // e seu campo de comentrios 
    public void InicializaVeiculo() {

        mensagem("Inicializando Veculos...");
        BoxVeiculos = new Choice();

        // Adio de Itens (ilustrativo para prottipo da aplicacao)
        BoxVeiculos.addItem("Veiculo 1");
        BoxVeiculos.addItem("Veiculo 2");
        BoxVeiculos.addItem("Veiculo 3");
        BoxVeiculos.addItem("Veiculo n");

        TxtVeiculos = new TextField("Comentarios adicionais sobre Veculos",16);

    	} 

    // Mtodo para inicializar a caixa de seleo das Encomendas
    // e seu campo de comentrios
    public void InicializaEncomenda() { 

        mensagem("Inicializando Encomendas...");
        BoxEncomendas = new Choice();
        
        // Adio de Itens (ilustrativo para prottipo da aplicacao)
        BoxEncomendas.addItem("Encomenda 1");
        BoxEncomendas.addItem("Encomenda 2");
        BoxEncomendas.addItem("Encomenda 3");
        BoxEncomendas.addItem("Encomenda n");

        TxtEncomendas = new TextField("Comentarios adicionais sobre Encomendas",16);
        
        }

     // Inicializa as Labels (Rtulos de texto) 
     public void InicializaRotulos() {

        mensagem("Inicializando Rtulos...");

        // Define Texto do Titulo do Applet
        FonteTitulo = new Font("TimesRoman",Font.BOLD,14); 
        LabelTitulo = new Label( TituloApplet );
        LabelTitulo.setFont(FonteTitulo);
      
        // Define Texto/Ttulo da Caixa de Seleo de Veculos
        FonteTitulo = new Font("Courier",Font.ITALIC,12); 
        LabelSelecVeiculo = new Label( "Selecione o veculo:" );
        LabelSelecVeiculo.setFont(FonteTitulo);
 
        // Define Texto/Ttulo da Caixa de Seleo das Encomendas
        FonteTitulo = new Font("Courier",Font.ITALIC,12); 
        LabelSelecEncomenda = new Label( "Selecione a encomenda:" );
        LabelSelecEncomenda.setFont(FonteTitulo);
     	
        } 

     // Inicializa as Estruturas de Canvas (Botes e Mapas)
     public void InicializaCanvas() {

        mensagem("Inicializando Canvas...");
        
        MapaReduzido = new CanvasMapaReduzido( 169,211,ImagemMapaReduzido );
        BotaoZoomIn = new CanvasBotaoZoomIn( 32,32, ImagemBotaoZoomIn);
        BotaoZoomOut = new CanvasBotaoZoomOut( 32,32, ImagemBotaoZoomOut);
        BotaoImprimir = new CanvasBotaoImprimir( 32,32, ImagemBotaoImprimir);
        BotaoMelhorCaminho = new CanvasBotaoMelhorCaminho( 32,32, ImagemBotaoMelhorCaminho);
        BotaoArquivoVeiculo = new CanvasBotaoArquivoVeiculo( 32,32, ImagemBotaoArquivoVeiculo);
        BotaoArquivoEncomenda = new CanvasBotaoArquivoEncomenda( 32,32, ImagemBotaoArquivoEncomenda);
        MapaCalculado = new CanvasMapaCalculado( 375,299,ImagemMapaCalculado );

     	}

     // Mtodo para adicionar os componentes ao Layout personalizado
     public void AdicionaComponentes() {
        
        mensagem("Adicionando Componentes ao Canvas...");
        
        add( LabelTitulo );
        add( LabelSelecVeiculo );
        add( LabelSelecEncomenda );
        add( MapaReduzido);
        add( BoxVeiculos );
        add( BoxEncomendas );
        add( BotaoZoomIn);
        add( BotaoZoomOut);
        add( BotaoImprimir);
        add( BotaoMelhorCaminho);
        add( BotaoArquivoVeiculo);
        add( BotaoArquivoEncomenda);
        add( MapaCalculado);
        add( TxtVeiculos);
        add( TxtEncomendas);

        }     	      

     // Mtodo para posicionar componentes na tela (posio absoluta)
     public void PosicionaComponentes() {

        // Agora usamos o mtodo "move" (que j implementamos no
        // layout personalizado) que nos permitir colocar os 
        // componentes nas posies desejadas 

        mensagem("Posicionando componentes na tela...");

        LabelTitulo.move( (size().width-TituloApplet.length()*6)/2,1 );
        LabelSelecVeiculo.move( 32,332 );
        LabelSelecEncomenda.move( 239,332 );
        BotaoZoomIn.move(439,255);  
        BotaoZoomOut.move(508,255);  
        BotaoImprimir.move(576,255);  
        BotaoMelhorCaminho.move(439,293);  
        BotaoArquivoVeiculo.move(508,293);  
        BotaoArquivoEncomenda.move(576,293);  
        MapaReduzido.move (439,32);
        MapaCalculado.move (32,32);
        BoxVeiculos.move(32,356); 
        BoxEncomendas.move(239,356);       
        TxtVeiculos.move(32,426);
        TxtEncomendas.move(239,426);
     	
     	}

     // Mtodo para exibir mensagens de status
     public void mensagem(String msg){ 
        System.out.println(msg);
        showStatus(msg);
        }

     public void EscolherArquivoVeiculo() {
        
        // Abrir Novo arquivo de veiculos
        mensagem("Escolha o Arquivo de Veculos a ser usado");
        
        FileDialog CaixaDialogoVeiculo = new FileDialog(new Frame(), "Escolha o arquivo de Veiculos", FileDialog.LOAD);
        CaixaDialogoVeiculo.setDirectory("."); // seta diretorio corrente
        CaixaDialogoVeiculo.show();
        
        if (CaixaDialogoVeiculo.getFile() != null) {
          BotaoArquivoVeiculo.ArquivoVeiculo = CaixaDialogoVeiculo.getFile(); 
          BotaoArquivoVeiculo.msg = "Abrir arquivo de Veiculos (Arquivo atual: "+BotaoArquivoVeiculo.ArquivoVeiculo+")" ;
          mensagem( BotaoArquivoVeiculo.msg );
        }
     	
     	}

     public void EscolherArquivoEncomenda() {
 
        // Abrir Novo arquivo de encomendas
        mensagem("Escolha o Arquivo de Encomendas a ser usado");
        
        FileDialog CaixaDialogoEncomenda = new FileDialog(new Frame(), "Escolha o arquivo de Encomendas", FileDialog.LOAD);
        CaixaDialogoEncomenda.setDirectory("."); // seta diretorio corrente
        CaixaDialogoEncomenda.show();
        
        if (CaixaDialogoEncomenda.getFile() != null) {
          BotaoArquivoEncomenda.ArquivoEncomenda = CaixaDialogoEncomenda.getFile(); 
          BotaoArquivoEncomenda.msg = "Abrir arquivo de Encomendas (Arquivo atual: "+BotaoArquivoEncomenda.ArquivoEncomenda+")" ;
          mensagem( BotaoArquivoEncomenda.msg );
        }
     	
     	
     	}

} // Final da classe Interface.java