// Last edited on 2024-06-04 17:06:23 by stolfi

#debug "!! Loading fan_partition.inc ...\n"

// These procedures add diagonals to some face of the objetct.
// Each procedure stores the new diagonals in {D[nd..]} and increments {nd}.
// Each {D[kd]} is a triple "{< kv_org, kv_dst, 0 >}", analogous to an original edge,
// where {kv_org,kv_dst} are the indices of the endpoint vertices (from 1, as in 
// the {V} array.

#macro fan_partition_one(V, kv0,kv1, D,nd)
  // Connects vertices {kv0} and {kv1}.
  #debug concat("!!   connecting ", str(kv0,0,0), " to ", str(kv1,0,0), " nd = ", str(nd,0,0))
  #local nd = nd + 1;
  #local D[nd] = < kv0, kv1, 0 >;
  #debug concat(" -> ", str(nd,0,0), "\n")
#end
      
#macro fan_partition_binary(V, kva,kvb, D,nd)
  // Connects vertices {kva..kvb} in binary fashion.
  
  #debug concat("!!   connecting binary {", str(kva,0,0), "..", str(kvb,0,0), "} nd = ", str(nd,0,0))
  #local ns = kvb - kva; // Number of diagonals at level 1 ({dv=2}).
  #if (ns < 0) kaboom("bad order {kva,kvb}") #end
  #local dv = 2;  // How many vertices to skip.
  #while (dv <= ns)
    #local kv0 = kva;
    #local kv1 = kv0 + dv;
    #while (kv1 <= kvb)
      #local nd = nd + 1;
      #local D[nd] = < kv0, kv1, 0 >;
      #local kv0 = kv1;
      #local kv1 = kv0 + dv;
    #end
    #if (kv0 != kvb) kaboom("{kvb-kva} is not a power of 2") #end 
    #local dv = 2*dv;
  #end
  #debug concat(" -> ", str(nd,0,0), "\n")
#end
      
#macro fan_partition_one_to_many(V, kvr, kva,kvb,d, D,nd) 
  // Connects {kvr} with {kva..kvb} with step {d}.

  #debug concat("!!   connecting ", str(kvr,0,0), " to {", str(kva,0,0), "..(", str(d,0,0), ")..",  str(kvb,0,0), "} nd = ", str(nd,0,0))
  #local ns = int((kvb - kva)/d);  // Number of diagonals minus one.
  #if (kvb-kva != ns*d) kaboom("bad {kva,kvb,d}") #end
  #if (ns < 0) #local ns = -ns; #end
  #for (ks,0,ns)
    #local kv1 = kva + ks*d;
    #local nd = nd + 1;
    #local D[nd] = < kvr, kv1, 0 >;
  #end
  #debug concat(" -> ", str(nd,0,0), "\n")
#end

#macro fan_partition_two_to_many(V, kvr,kvs,  kva,kvb,d, D,nd)
  // Connects {kvr,kvs} with {kva..kvb} in steps of {d}
  // Tries to split evenly the diagonals.
  // One vertex in {kva..kvb} gets two diagonals.
  
  #local ns = int((kvb-kva)/d); // Number of diagonals minus two.
  #if (kvb - kva != ns*d) kaboom("bad {kva,kvb,d}") #end
  #if (ns < 0) #local ns = -ns; #end
  
  // Connect {kvr} with first half of {kva..kvb}:
  #local ns_0 = int(ns/2); // Number of diagonals in first half minus one.
  #local kva_0 = kva; 
  #local kvb_0 = kva + ns_0*d; 
  fan_partition_one_to_many(V, kvr,  kva_0,kvb_0,+d, D,nd)

  #if (ns_0 < ns)
    #local ns_1 = (ns + 2) - (ns_0 + 1) - 1; // Number of diagonals in second half minus one.
    #local kva_1 = kvb; 
    #local kvb_1 = kvb - ns_1*d; 
    fan_partition_one_to_many(V, kvs,  kva_1,kvb_1,-d, D,nd)
  #end
#end

#macro fan_partition_zipper(V, kva,kvb,dab,  kvc,kvd,dcd, D,nd)
  // Connects {kva..kvb} with step {dab} to {kvc..kvd} with step {dcd}.
  
  #debug concat("!!   connecting {", str(kva,0,0), "..(", str(dab,0,0), ")..",  str(kvb,0,0), "}")
  #debug concat(" to {", str(kvc,0,0), "..(", str(dcd,0,0), ")..",  str(kvd,0,0), "} nd = ", str(nd,0,0))
  
  #local ns = int((kvb-kva)/dab); // Number of diagonals minus one.
  #if (kvb-kva != ns*dab) kaboom("bad step {kva,kvb,dab}") #end
  #if (kvd-kvc != ns*dcd) kaboom("bad step {kvc,kvd,dcd}") #end
  #if (ns < 0) #local ns = -ns; #end
  
  #for (ks,0,ns)
    #local kv0 = kva + ks*dab;
    #local kv1 = kvc + ks*dcd; 
    #local nd = nd + 1;
    #local D[nd] = < kv0, kv1, 0 >;
  #end
  #debug concat(" -> ", str(nd,0,0), "\n")
#end
