/* Last edited on 2007-01-07 23:18:01 by stolfi */

/* ---------------------------------------------------------------------- */
/* IEEEAP.c */

        FILE* pp = popen("gnuplot >& /dev/null", "w");
	if (pp == NULL) fatal("cannot open gnuplot");
	fputs("set data style lines\n", pp);
	fputs("set grid\n", pp);
	fprintf(pp, "set xrange [%g:%g]\n", -dx, (n+0.5)*dx);
	fprintf(pp, "set yrange [%g:%g]\n", -dy, (n+0.5)*dy);
     	//fprintf(pp, "set yrange [%g:%g]\n", -0.05, 0.05);
	//sprintf(buf, "set title 'Time = %g ns'\n", k * dt * 1e9);
	fputs(buf, pp);
	fputs("splot '-' t 'FDTD2d' w line\n", pp);
	for (i=0; i <=n; i++)
	   for (j=0; j <=n; j++)
	       fprintf(pp, "%g\t%g\t%g\n", i*dx, j*dy, hz[i][j]);
	fputs("e\n", pp);
	fflush(pp);

/* ---------------------------------------------------------------------- */
      sprintf(buf, "set title 'Time = %g ns'\n", k * dt * 1e9);
      fputs(buf, pp);
      fputs("splot '-' t 'FD' w line\n", pp);
      for (i=0; i <=n; i++)
        for (j=0; j <=n; j++)
          fprintf(pp, "%g\t%g\t%g\n", i*dx, j*dy, az[i][j]);
      fputs("e\n", pp);
      fflush(pp);
/* ---------------------------------------------------------------------- */
  pclose(pp);
/* ---------------------------------------------------------------------- */

/* ---------------------------------------------------------------------- */
/* wplot_ag.c */

char *WPlot_readString(FILE *rd);
  /* Reads from {rd} a string delimited by double quotes. */

#define WPlot_MAXSTRING 500

char *WPlot_readString(FILE *rd)
{
  char buf[WPlot_MAXSTRING];
  int c = fgetc(rd);
  while ((c == ' ') || (c == '\n') || (c == '\015') || (c == '\011'))
    { c = fgetc(rd); }
  if (c == EOF) 
    { fprintf(stderr, "expected string, found end-of-file\n"); exit(-1); }
  if (c != '"') 
    { fprintf(stderr, "expected string, found '%c'\n", c); exit(-1); }
  int n = 0;
  c = fgetc(rd);
  while ((c != EOF) && (c != '"') && (c != '\n') && (c != '\015'))
    { if (n >= WPlot_MAXSTRING) 
        { fprintf(stderr, "string too long - max %d\n", WPlot_MAXSTRING); exit(-1); }
      buf[n] = c; n++;
      c = fgetc(rd);
    }
  if (c != '"') 
    { fprintf(stderr, "missing final '\"'\n"); exit(-1); }
  char *r = malloc(n+1);
  if (r == NULL) { fprintf(stderr, "out of memory\n"); exit(-1); }
  int i;
  for (i = 0; i < n; i++) { r[i] = buf[i]; }
  r[n] = 0;
  return r;
}

void WPlot_Print(FILE *wr, WPlot_t *wp)
{
  fprintf(wr, "%13.5e %13.5e\n", wp->xMin, wp->xMax);
  fprintf(wr, "%13.5e %13.5e\n", wp->yMin, wp->yMax);
  fprintf(wr, "%13.5e %13.5e\n", wp->zMin, wp->zMax);
  fprintf(wr, "%d\n", wp->fixZRange);
  fprintf(wr, "%d %d\n", wp->gnuplotOption, wp->terminalOption);
  fprintf(wr, "%d\n", wp->screenNumber);
  fprintf(wr, "%d\n", wp->paletteKind);
  fprintf(wr, "%d %d\n", wp->splotOption, wp->splotDesignOption);
  fprintf(wr, "\n");
}

void WPlot_setWPlotGnuplot(WPlot_t *wp, char *fileNameCfg)
{
  fprintf(stdout, "%s", fileNameCfg);
  FILE *rd = fopen(fileNameCfg, "r");
  if (rd == NULL)
    { fprintf(stderr, "Could not open config file \"%s\" !!\n", fileNameCfg);
      exit(1);
    }
  fscanf(rd, "%le %le", &(wp->xMin), &(wp->xMax));
  fscanf(rd, "%le %le", &(wp->yMin), &(wp->yMax));
  fscanf(rd, "%le %le", &(wp->zMin), &(wp->zMax));
  int x;
  fscanf(rd, "%d", &x);  wp->fixZRange = (x != 0);
  fscanf(rd, "%d %d", &(wp->gnuplotOption), &(wp->terminalOption));
  fscanf(rd, "%d", &(wp->screenNumber));
  fscanf(rd, "%d", &(wp->paletteKind));
  fscanf(rd, "%d %d", &(wp->splotOption), &(wp->splotDesignOption));
  fclose(rd);
}


