#ifndef frb_proc_H
#define frb_proc_H

/* Useful miscellaneous functions  */
/* Last edited on 2005-01-01 11:36:41 by stolfi */

int frb_imax ( int A, int B );
int frb_imin ( int A, int B );
  /* Maximum and minimum for {int}s. */

double frb_dmax ( double A, double B );
double frb_dmin ( double A, double B );
  /* Maximum and minimum for {double}s. */

int frb_imod ( int A, int B );
  /* Mathematical remainder of {A} by {B}.
    Requires {B>0} and returns result in {[0..B-1]} even
    when {A} is negative. */

int frb_round ( double x );

void frb_reduce_to_period
  ( double *t, /* IO */  
    double tLo,
    double tHi, 
    int *k  /* OUT */
  );
  /*
    Reduces {*t} to the range {[tLo _ tHi)} by adding to it
    some integer multiple {kk} of {tHi - tLo}. Returns {kk} in {*k}. */

double frb_adjust_unit
  ( double givenUnit, 
    double dev,
    double big 
  );
  /*
    Adjusts the {givenUnit} for quantization of a variable 
    whose standard deviation is {dev} and whose values range
    in {[-big..+big]}.  Will increase {givenUnit} if needed to 
    avoid overflow, or decrease it to ensure quantization errors
    less than dev*10^-6.  In any case, if {givenUnit} is changed,
    or no good unit was found, also prints a warning to {stderr}. */

#endif
