#ifndef frb_signal_H
#define frb_signal_H

/* Sequences (possibly periodic) of {double}s --- times, labels, curvatures, etc. */
/* Last edited on 2004-12-31 12:20:03 by stolfi */

#include <frb_segment.h>
#include <frb_types.h>
#include <r2.h>

typedef double_vec_t frb_signal_t;
  /* A {frb_signal_t} is a sequence, open or closed, of arbitrary double
    values.  If closed, the elements may be samples from a periodic
    function, or from the integral of a periodic function. */

#define frb_signal_new double_vec_new

void frb_zero_signal (frb_signal_t *sg);
  /* Sets {sg.el[i] = 0} for all {i}. */

void frb_signal_write
  ( FILE *wr,
    char *cmt,
    frb_signal_t *c,
    double stride,
    double unit
  );
  /*
    Writes signal {c} to {wr}, prefixed with comments {cmt} and the
    given {stride}. The samples will be written as integer multiples
    of the given {unit}. */

typedef
  struct frb_signal_read_data_t
    { char *cmt;             /* Comments */
      int samples;           /* Number of samples in signal. */
      frb_signal_t c;        /* The signal proper. */
      double stride;         /* Period, total length, etc; 0 if not applicable. */
      double unit;           /* Unit used when recording the samples */
    } frb_signal_read_data_t;

frb_signal_read_data_t frb_signal_read ( FILE *rd, bool_t header_only );
  /* frb_signal_reads a signal from {rd}. If {header_only==TRUE}, reads only the
    parameters, and leaves the {c} field as NULL. */

typedef
  struct frb_signal_list_read_data_t
    { frb_signal_read_data_t *sgData;
      double unitMin; /* Minimum quantization unit. */
      double unitMax; /* Maximum quantization unit. */
      char *cmt;      /* Comment of first signal, if any. */
    } frb_signal_list_read_data_t;
  
frb_signal_list_read_data_t frb_signal_list_read
  ( char *dir,
    char *fileName,
    bool_vec_t *sel,
    bool_t header_only
  );
  /* Reads a set of numbered signals, returns a
    {frb_signal_list_read_data_t} record {r}. Signal number {i} is
    read if and only if {sel[i] == TRUE}, and its
    {frb_signal_read_data_t} is stored in {r.signal[i]}; otherwise
    {r.signal[i] } is set to a record with null {c} field.

    The data is read from file "{dir}/{NNNNNN}/{fileName}", {NNNNNN}
    is the signal number {k} (6 digits, zero padded).

    If {header_only} is TRUE, only the header of each file is read;
    the {c} fields are all set to NULL.

    The range of quantization {unit}s of the signals that were read is
    returned in {r.unitMin}, {r.unitMax}.  The comment of the first signal
    read, plus the call arguments, are stored in {r.cmt}. */


#endif
