#ifndef frb_types_H
#define frb_types_H

/* Basic types for information analysis of matched fracture lines */
/* Last edited on 2007-01-04 00:13:53 by stolfi */

#define INF MAXDOUBLE

#define Pi (3.14159265358979323)

#include <i2.h>
#include <r3.h>
#include <vec.h>

/* INTERVALS */

typedef
   struct frb_range_t { double end[2]; } frb_range_t;

/* SIGNED BYTES */

typedef signed char sbyte;

vec_typedef(sbyte_vec_t,sbyte_vec,sbyte);
  /* A vector of signed bytes ({sbyte}s). */

#endif
