/* See frb_window.h */
/* Last edited on 2004-12-31 12:20:05 by stolfi */

#include <frb_window.h>
#include <frb_types.h>
#include <frb_proc.h>

#include <nget.h>
#include <fget.h>
#include <filefmt.h>

bool_t frb_window_is_empty ( frb_window_t *w )
  { return 
      (w->r[0].end[0] >= w->r[0].end[1]) ||
      (w->r[1].end[0] >= w->r[1].end[1]);
  }
  
frb_window_t frb_window_join ( frb_window_t *w1, frb_window_t *w2 )
  { frb_window_t wr;
    int ax;
    for (ax = 0; ax < 2; ax++)
      { wr.r[ax].end[0] = frb_dmin(w1->r[ax].end[0], w2->r[ax].end[0]);
        wr.r[ax].end[1] = frb_dmax(w1->r[ax].end[1], w2->r[ax].end[1]);
      }
    return wr;
  }

frb_window_t frb_window_expand ( frb_window_t *w, double rel )
  { frb_window_t wr;
    int ax;
    for (ax = 0; ax < 2; ax++)
      { double extra = rel*frb_dmax(1.0e-100, w->r[ax].end[1] - w->r[ax].end[0]);
        wr.r[ax].end[0] = w->r[ax].end[0] - extra;
        wr.r[ax].end[1] = w->r[ax].end[1] + extra;
      }
    return wr;
  }

#define WindowFileVersion "2004-04-30"

frb_window_t frb_window_read( FILE *rd )
  {
    frb_window_t w;
    filefmt_read_header(rd, "frb_window_t", WindowFileVersion);
    w.r[0].end[0] = nget_double(rd, "XMin"); fget_eol(rd); 
    w.r[0].end[1] = nget_double(rd, "XMax"); fget_eol(rd); 
    w.r[1].end[0] = nget_double(rd, "YMin"); fget_eol(rd); 
    w.r[1].end[1] = nget_double(rd, "YMax"); fget_eol(rd); 
    filefmt_read_footer(rd, "frb_window_t");
    return w;
  }

