#ifndef frb_window_H
#define frb_window_H

/* A frb_window_t is a box (axis-aligned rectangle) on the plotting plane. */
/* Last edited on 2004-12-31 12:19:41 by stolfi */

#include <frb_types.h>

typedef
   struct frb_window_t { frb_range_t r[2]; } frb_window_t;

bool_t frb_window_is_empty ( frb_window_t *w );
  /*
    TRUE if {w} is empty or reduces to a single point. */

frb_window_t frb_window_join ( frb_window_t *w1, frb_window_t *w2 );
  /*
    The smallest box that contains {w1} and {w2}. */

frb_window_t frb_window_expand ( frb_window_t *w, double rel );
  /*
    Enlarges {w} on all four sides by {rel} times its maximum extent. */

frb_window_t frb_window_read( FILE *rd );
  /*
     Reads a window from {rd}. */

#endif
