#! /bin/bash
# Last edited on 2010-08-12 13:46:05 by stolfilocal

# Uses the preliminary groundtruth image and the homogeneous text masks
# to cut out the text characters and a bit of the surrounding background.
# Then computes the histogram of the image and displays it.

# Input files:
#   orig/${inum}.png         -- official image
#   ptru/${inum}.png         -- preliminary groundtruth image
#   rmsk/${inum}-${tnum}.png -- homogeneous text region mask.

# Output files:
#   pmsk/${inum}-${tnum}.png -- mask for chars + surround
#   pext/${inum}-${tnum}.png -- chars + surround extracted from "orig" with "pmsk".

function extr() {

  inum="$1"; shift;   # Image id-number.
  tnum="$1"; shift;   # Id-number of homogeneous text region in image.
  lamb="$1"; shift;   # Minimum characterisic wavelength of text.
  brad="$1"; shift;   # Blur radius for original image.

  # Make sure that the output directories exist:
  mkdir -p pmsk pext

  # Main files:
  origimg="orig/${inum}.png" # The official version of the image.
  ptruimg="ptru/${inum}.png" # The preliminary groundtruth image.
  rmskimg="rmsk/${inum}-${tnum}.png" # The rough "homogeneous text region" mask.
  pmskimg="pmsk/${inum}-${tnum}.png" # The region's text+surround mask.
  pextimg="pext/${inum}-${tnum}.png" # The region's extracted text+surround image.

  # Work files:
  temp="/tmp/$$"
  tempimg="${temp}-x.png" # A temporary scratch image.

  # Compute the dilation radius for masking:
  drad=`gawk -v lamb="${lamb}" 'BEGIN{ e = 2.5; r = 0.5*lamb; drad = sqrt(e*e + r*r); printf "%.2f", drad; }' `

  # Compute the blur radius for mask feathering:
  frad=`gawk -v drad="${drad}" 'BEGIN{ frad = 0.25*drad; printf "%.2f", frad; }' `

  # Generate ${pmskimg} from ${ptruimg} and ${rmskimg}:
  convert \
    -compose Multiply \
    ${ptruimg} \
    -alpha Off \
    -negate \
    ${rmskimg} \
    -alpha Off \
    -composite \
    -morphology Dilate Disk:"${drad}" \
    -gaussian-blur "x${frad}" \
    ${pmskimg}

  # Extract the text from the "orig" image:
  # echo "extracting text from ${origimg} with ${pmskimg} ..." 1>&2
  # identify ${pmskimg}
  # identify ${origimg}
  # Threshold the mask and dilate it some more to get a cookie cutter:
  convert \
    ${pmskimg} \
    -alpha Off \
    -threshold 1 \
    -morphology Dilate Disk:1.5 \
    ${origimg} \
    -alpha Off \
    -gaussian-blur "x${brad}" \
    -compose Multiply \
    -composite \
    ${pmskimg} \
    -compose CopyOpacity \
    -composite \
    -trim \
    ${pextimg}

  # identify ${pextimg}
  # display -title "${inum}-${tnum}" ${pextimg} ${ptruimg} ${pmskimg}

  # rm -f ${temp}-*.png
}

extr 001 000  4.0 0.5 # "DANCE PARTY ... COOKS"
extr 001 001  4.0 0.5 # "ATM"
extr 001 002  2.0 0.5 # "INSIDE"
extr 002 000 10.0 0.5 # "RETAIL FISH  KET"
extr 002 001  7.0 0.5 # "CLAM BAR"
extr 003 000  5.0 0.5 # "BROOKLYN SUPERHERO SUPPLY"
extr 004 000  6.0 0.5 # "BOHOL PROVINCE IS"
extr 004 001  7.0 0.5 # "GMO-FREE"
extr 004 002  3.0 0.5 # "No.2003-010"
extr 004 003  5.0 0.5 # "GENETICALLY MODIFIED (GM)"
extr 004 004  4.0 0.5 # "Under ... imprisonment."
extr 005 000  2.0 0.5 # "ESS"
extr 005 001 13.0 0.5 # "E" [drop-shadowed]
extr 005 002  4.0 0.5 # "RENT"
extr 005 003  1.4 0.5 # [Chinese text]
extr 005 004  7.0 0.5 # "y Inc."
extr 005 005  2.0 0.5 # "718-621-3598"
extr 005 006  2.0 0.5 # "KNOWN"
extr 005 007  2.0 0.5 # "QUALITY"
extr 005 008  8.0 0.5 # "BARI PORK STORE"
extr 005 009  5.0 0.5 # "KING OF THE SAUSAGE"
extr 005 010  4.0 0.5 # "LATTICINI"
extr 005 011  4.0 0.5 # "WE CATER"
extr 005 012  5.0 0.5 # "SALUMERIA"
extr 005 013  8.0 0.5 # "MED"
extr 005 014  4.0 0.5 # "6321 18"
extr 005 015  6.0 0.5 # "Moder" [script]
extr 005 016  4.0 0.5 # "MEDICAL-DENTAL"
extr 005 017  2.0 0.5 # "OFFICES"
extr 005 018  3.0 0.5 # "718-331-6060"
extr 005 019  6.0 0.5 # "PORK STORE"
extr 005 020  3.0 0.5 # "Fine Foods"
extr 005 021  2.2 0.5 # "FREE DELIVERY"
extr 005 022  3.6 0.5 # "837-9773"
extr 005 023  4.0 0.5 # "DENTIST" [vertical]
extr 005 024  4.0 0.5 # "HOT"
extr 005 025  4.0 0.5 # "& COLD."
extr 005 026  3.0 0.5 # "Catering" [script]
extr 005 027  4.4 0.5 # "4"
extr 005 028  3.6 0.5 # "3"
extr 005 029  3.0 0.5 # "2"
extr 005 030  3.0 0.5 # "2"
extr 005 031  2.0 0.5 # "4"
extr 005 032  1.6 0.5 # "BUSINESS  CENTER  INTERNET  COMPUTER  COPIES"
extr 006 000  7.0 0.5 # "JACKIE ROBINSON SCHOOL"
extr 007 000  4.4 0.5 # "RED HOOK"
extr 007 001  3.6 0.5 # "COMMUNITY"
extr 007 002  5.0 0.5 # "FARM"
extr 008 000  8.0 0.5 # "MADISON SQUARE GARDEN"
extr 008 001  8.0 0.5 # ">>----  ----->"
extr 009 000  9.0 0.5 # "RADIO CITY"
extr 009 001  5.6 0.5 # "IO CITY" [slantview]
extr 009 002 16.0 1.5 # "RAD"
extr 009 003  3.0 0.5 # "O CITY" [slantview]
extr 009 004  4.0 0.5 # "Music Hall"
extr 009 005  6.0 0.5 # "Music" [semi-script]
extr 009 006  4.0 0.5 # "Hall" [semi-script]
extr 009 007  3.0 0.5 # "L"
extr 009 008  3.0 0.5 # "L A"
extr 009 009  3.5 0.5 # "U"
extr 009 010  3.5 0.5 # "GUST"
extr 009 011  3.5 0.5 # "21  ON SALE NOW"
extr 010 000  7.0 0.5 # "Punta Cana, DO"
extr 010 001  5.5 0.5 # "1781  9:30am"
extr 010 002  5.0 0.5 # "Flight:  Departs:"
extr 010 003  6.5 0.5 # "Standby List"
extr 010 004  6.0 0.5 # "1 PAY/L  2 PAY/J"
extr 011 000  4.0 0.5 # "NYPD"
extr 012 000 12.0 0.5 # "BROOKLYN VI"
extr 012 001  5.0 0.5 # "WWW.BROOKLYNVIFISHING.COM"
extr 012 002  4.0 0.5 # "DAY :00 AM"
extr 012 003  8.0 0.5 # "7"
extr 012 004  4.0 0.5 # "WINTER"
extr 012 005  3.0 0.5 # "BLACKFISH·COD·MACKEREL·"
extr 012 006  2.0 0.5 # "OFFSHORE TRIPS"
extr 012 007  8.0 0.5 # "40"
extr 012 008  3.6 0.5 # "YEARS"
extr 012 009  4.0 0.5 # "EXP."
extr 012 010  4.0 0.5 # "SUMMER"
extr 012 011  3.0 0.5 # "BLUES·BONITA·ALBACORE·TUNA·STRIPED BASS·"
extr 012 012  2.4 0.5 # "DAY & NIGHT"
extr 012 013  3.0 0.5 # ":00"
extr 012 014  1.0 0.5 # "AM & PM"
extr 012 015  8.0 0.5 # "7"
extr 012 016  8.0 0.5 # "SPEED"
extr 012 017  6.0 0.5 # "COMFORT"
extr 012 018  8.0 0.5 # "(718)"
extr 012 019  8.0 0.5 # "743-8464"
extr 012 020  5.0 0.5 # "CHARTERS AVAILABLE"
extr 012 021  2.0 0.5 # "Capt. Bob ... Crew."
extr 012 022  3.0 0.5 # "``Fishings Finest 110 Foot''" [script]
extr 013 000  4.0 0.5 # "Climate Change Affects Everyone"
extr 013 001  7.0 0.5 # "3,641,933,218,891"
extr 013 002  4.0 0.5 # "Greenhouse Gases In Our Atmosphere"
extr 014 000 20.0 0.5 # "BAKERY"
extr 014 001  4.0 0.5 # "Coffee"
extr 014 002  6.0 0.5 # "WEDDING CAKES" [vertical]
extr 015 000  4.0 1.0 # "SUPERNATURE!"
extr 015 001  3.0 1.0 # "RINGMASTERS OF"
extr 015 002  3.0 1.0 # "FIRE+BRIMSTONE!"
extr 015 003  3.0 1.0 # "KNOWN TO MAN!"
extr 015 004  2.6 1.0 # "WONDER+ENCHANTMENT!"
extr 015 005  5.0 1.0 # "ROCK + ROLL"
extr 015 006 15.0 1.0 # "CIRCUS"
extr 015 007  2.6 1.0 # "WHERE ? IN BROOKLYN  OF ALL PLACES!"
extr 015 008  5.0 1.0 # "OF THE"
extr 015 009  4.0 1.0 # "WORLD"
extr 015 010  5.0 1.0 # "AWAIT"
extr 015 011 11.0 1.0 # "YOU"
extr 015 012  3.0 1.0 # "FOR ENTRY"
extr 015 013  3.0 1.0 # "LIVE MUSICAL PERFORMANCES BY"
extr 015 014  7.0 1.0 # "N.E.R.D. M.I.A."
extr 015 015  3.0 1.0 # "HOT CHIP"
extr 015 016 12.0 1.0 # "ADMIT ONE"
extr 015 017  5.0 1.0 # "SATURDAY ... BROOKLYN"
extr 015 018  8.0 1.0 # "XXX"
extr 015 019  8.0 1.0 # "XXX"
extr 016 000 15.0 0.5 # "HOUSTON"
extr 016 001  3.4 0.5 # "MIXED BY DJ AYRES & JD"
extr 016 002  3.0 0.5 # "ROCKS IT" [panorama]
extr 016 003  3.6 0.5 # "BONUS CD - DJ ELEVEN" [circle]
extr 017 000  2.4 0.5 # "e u r o"
extr 017 001 11.0 0.5 # "TRIP"
extr 017 002  2.4 0.5 # "restaurant & bar"
extr 018 000 10.0 0.5 # "Welcome to"
extr 018 001 12.0 0.5 # "London King's Cross"
extr 018 002  3.0 0.5 # [logo]
extr 019 000 20.0 0.5 # "COME IN AND"
extr 019 001 16.0 0.5 # "HAVING THE BEST"
extr 019 002 16.0 0.5 # "BIKINI  MEN  WOMEN"
extr 019 003 14.0 0.5 # "PRICE  FOR  AND"
extr 020 000 10.0 0.5 # "DON'T TRASH SHASTA !"
extr 020 001  4.8 0.5 # "REPORT ILLEGAL ... -TRASH"
extr 020 002 10.0 0.5 # "$1,000 FINE FOR ILLEGAL DUMPING"
extr 020 003 12.0 0.5 # "THIS AREA ... PC 374.3"
extr 021 000  6.0 0.5 # "CHILDREN LEFT ... FREE KITTEN"
extr 022 000 11.0 0.5 # "ZODIAC STYLE:"
extr 022 001 10.0 0.5 # "WATER SIGNS"
extr 023 000 14.0 0.5 # "WARNING"
extr 023 001 11.0 0.5 # "BEWARE OF ALLIGATORS AND SNAKES"
extr 023 002  8.0 0.5 # "AND DWARVES" [handprint]
extr 023 003  5.0 0.5 # "+ Julia Roberts" [handprint]
extr 024 000  6.0 0.8 # "PIS"
extr 024 001  2.4 0.8 # "AQUATIC CENTRE"
extr 024 002  2.4 0.8 # "021-271861"
extr 024 003 11.0 1.0 # "Coffee Quarter" [smallcaps]
extr 024 004  6.0 1.0 # "Coffee Quarter" [smallcaps thick]
extr 024 005  9.0 1.0 # "Q" [mirrored L-R]
extr 024 006  4.0 1.0 # "COFFEE QUARTER" [crossed on first E]
extr 025 000 10.0 0.5 # "NORTH"
extr 025 001 11.0 0.5 # "110"
extr 025 002 12.0 0.5 # "Pasadena"
extr 025 003  5.0 0.5 # "TRUCKS  NO TRUCKS"
extr 026 000 41.0 0.5 # "Our Homes"
extr 026 001 20.0 0.5 # "Not GU's Dorm"
extr 026 002  9.0 0.5 # "burleith.org"
extr 026 003  9.0 0.5 # "Visit  for more information"
extr 027 000 22.0 0.5 # "F"
extr 027 001 22.0 0.5 # "M"
extr 027 002 22.0 0.5 # "L"
extr 027 003 10.0 0.5 # "PATH"
extr 027 004 22.0 0.5 # "->"
extr 028 000 15.0 1.0 # "NO"
extr 028 001 12.0 1.0 # "TRESPASSING"
extr 028 002 10.0 1.0 # "VIOLATORS ... SHOT AGAIN"
extr 029 000 48.0 3.0 # "STOP"
extr 029 001 15.0 3.0 # "AND SMELL THE ROSES"
extr 030 000  5.0 0.5 # "OBAMA'S PLAN"
extr 030 001  5.0 0.5 # "WHITE SLAVERY"
extr 031 000 13.0 0.5 # "Katrina T. Bartschy" [smallcaps][typeset]
extr 031 001  5.0 0.5 # "Your Hometown Realtor" [semi-callig][typeset]
extr 031 002 18.0 0.5 # "/"[typeset]
extr 031 003 18.0 0.5 # "RE MAX" [overlapping letters][typeset]
extr 031 004 13.0 0.5 # "Masters"[typeset]
extr 031 005  9.0 0.5 # "R" [split][typeset]
extr 031 006 13.0 0.5 # "(419) 704-0804"[typeset]
extr 032 000 12.0 0.5 # "Architects" [smallcaps]
extr 033 000 26.0 0.5 # "U MANCH"
extr 033 001 26.0 0.5 # "F  U"
extr 033 002  5.0 0.5 # "Signs of Infinite Power"
extr 034 000  2.6 0.5 # "MISS HAWAIIAN TROPIC ... 1999"
extr 034 001  2.4 0.5 # "Tropic" [semi-script]
extr 034 002  3.0 0.5 # "HAWAIIAN" [circle]
extr 035 000  5.0 1.0 # "NONE OF OUR HYMNS"
extr 035 001  9.0 1.0 # "ARE TESTED ON LIVE ANIMALS"
extr 036 000 20.0 0.5 # [right-arrow]
extr 036 001  8.0 0.5 # "This Guy is an IDIOT!"
extr 036 002 26.0 0.5 # [left-arrow]
extr 036 003 12.0 0.5 # "NO, HE's the IDIOT!!"
extr 036 004 16.0 0.5 # "AM NOT!"
extr 036 005 17.0 0.5 # "ARE TOO!"
extr 036 006  6.0 0.5 # "Leave me alone, ... sign!"
extr 037 000 10.0 0.5 # "WELCOME  TO"
extr 037 001 30.0 0.5 # "Nevada"
extr 037 002  6.0 0.5 # "Help Yourself To Our Whores And Drugs"
extr 038 000 12.0 0.5 # "CAUTION  ONE LANE  AHEAD" [dotted]
extr 039 000 22.0 0.5 # "CAESARS" [Greekish]
extr 039 001 10.0 0.5 # "BROOKDALE"
extr 039 002  6.0 0.5 # "BEACH BOYS ATE OUR BABYS BONER"
extr 039 003  6.0 0.5 # "VACANCY"
extr 039 004  4.6 0.5 # "College Humor" [semi-calli]
extr 040 000 12.0 1.5 # "Saturday" [smallcaps,hand]
extr 040 001 13.0 1.5 # "`Dark Market'" [smallcaps,hand]
extr 040 002 13.0 1.5 # "1 pm-  2pm-  3pm-" [smallcaps,hand]
extr 040 003 15.0 1.5 # "Improvisation" [smallcaps,hand]
extr 040 004  7.0 1.5 # "All  6th Avenue ... Jade *" [hand]
extr 040 005  9.0 1.5 # "wit 90" [smallcaps,hand]
extr 040 006  5.0 1.5 # "fre" [smallcaps,hand]
extr 041 000 24.0 0.5 # "TREETOPS"
extr 041 001  9.0 0.5 # "OF ANDERSON"
extr 042 000 15.0 0.5 # [Chinese text]
extr 042 001 10.0 0.5 # "Mobilephone electrizing"
extr 043 000  3.0 0.5 # "BUY  SELL TRADE"
extr 043 001  3.0 0.5 # "DI MONDS"
extr 043 002  2.4 0.5 # "UNLIMITED"
extr 043 003  9.0 0.5 # "FREE APPRAISAL  FAST PAYMENT"
extr 043 004  9.0 0.5 # "WE BUY - TRADE   FAIREST PRICES"
extr 043 005  2.4 0.5 # "1 800 428-2422"
extr 044 000 14.0 0.5 # "WE SELL"
extr 044 001 28.0 0.5 # "N"
extr 044 002 28.0 0.5 # "E"
extr 044 003 28.0 0.5 # "ON"
extr 045 000 16.0 0.5 # "vodafone"
extr 046 000  6.6 0.5 # "315"
extr 046 001  8.0 0.5 # [slippery symbol]
extr 046 002  4.0 0.5 # [no-flowers symbol]
extr 046 003  3.0 0.5 # [silence symbol]
extr 046 004  7.0 0.5 # "STOP"
extr 046 005  2.2 0.5 # "PROTECTIVE"
extr 046 006  4.0 0.5 # "ISOLATION"
extr 047 000 13.0 0.5 # "LAKESIDE"
extr 047 001 20.0 0.5 # "CLEANERS"

extr 047 002  4.0 0.5 # "QUALITY"
extr 047 003  4.0 0.5 # "DRY CLEANING" [half-shadowed]
extr 047 004  8.0 0.5 # "30% OFF" [half-shadowed]
extr 047 005  6.0 0.5 # "DRY CLEANING"
extr 047 006  4.0 0.5 # "SAME DAY  SERVICE  Monday-Friday Only"
extr 047 007  5.0 0.5 # "OPEN"
extr 047 008  7.0 0.5 # "104"
extr 048 000  2.2 0.5 # "KleberG" [smallcaps]
extr 048 001  4.0 0.5 # "FRANK"
extr 048 002  4.5 0.5 # "MACIAS"
extr 048 003 13.0 0.5 # "FAROUK"
extr 048 004  5.0 0.5 # "TEXAS GOVERNOR"
extr 048 005  4.5 0.5 # "CHEW"
extr 048 006  3.0 0.5 # "RE-ELECT"
extr 048 007 10.0 0.5 # "DAN"
extr 048 008  2.2 0.5 # "RE-ELECT  PROBATE COURT #1"
extr 048 009 12.0 0.5 # "HAGGERTY"
extr 048 010 10.3 0.5 # [star]
extr 048 011  5.0 0.5 # [6 stars]
extr 048 012  4.0 0.5 # "Precinct #4"
extr 048 013  5.5 0.5 # "COMMISSIONER"
extr 048 014  3.8 0.5 # "Yvonne"
extr 048 015  3.0 0.5 # [checked box]
extr 048 016  3.0 0.5 # [checked box]
extr 048 017  6.0 0.5 # "JUDGE  RODRIGUEZ"
extr 049 000 12.0 0.5 # "South Turner"
extr 049 001  7.0 0.5 # "St."
extr 050 000 27.0 0.5 # "OPEN"
extr 050 001  6.0 0.5 # [copyright] "ResignSign.com" [typeset-over]
extr 051 000 10.0 0.5 # "Happy"
extr 051 001 10.0 0.5 # "B-day"
extr 051 002 10.0 0.5 # "Ryan"
extr 052 000  5.0 0.5 # "COPS" [handprint]
extr 052 001  4.0 0.5 # "IN 1965  FOR" [handprint]
extr 052 002  5.5 0.5 # "BEATEN BY  STILL WAITING" [handprint]
extr 052 003  4.5 0.5 # "EQUAL RIGHTS"
extr 053 000  6.0 0.5 # "I'M A PENGUIN"
extr 053 001  5.0 0.5 # "If I smell it's because  and I eat fish."
extr 054 000 23.0 0.5 # "ADULT W RLD"
extr 054 001  5.0 0.5 # "DONT FORGET MOM  ON  MOTHERS DAY"
extr 055 000 43.0 1.0 # "Think"
extr 056 000  5.0 0.5 # [logo]
extr 056 001  6.0 0.5 # "First Baptist Church"
extr 056 002  8.0 0.5 # "JESUS SAYS ... WITH YOU"
extr 056 003  3.5 0.5 # "WORSHIP ... 8:30AM"
extr 057 000 12.0 1.5 # "TICUL"
extr 057 001 12.0 1.5 # "OXKUTZCAB"
extr 057 002 25.0 1.5 # [up-arrow]
extr 057 003 25.0 1.5 # [left-arrow]
extr 058 000 14.0 1.0 # "RECEPTION"
extr 059 000  9.0 0.5 # "NEIGHBORHOOD ZONE"
extr 059 001 31.0 0.5 # "SL W  DOWN!"
extr 059 002  3.0 0.5 # "peds.org"
extr 059 003  2.2 0.5 # "PEDS"
extr 060 000 10.0 0.5 # "DO NOT  EXERCISE ... ESTATE."
extr 061 000 16.0 0.5 # "ZOMBIES  AHEAD"
extr 062 000  7.0 0.5 # "FIRST BAPTIST CHURCH"
extr 062 001  7.0 0.5 # "Sunday Services ... Pastor" [smallcaps]
extr 063 000 19.0 0.5 # "<EXIT>"
extr 063 001 19.0 0.5 # "<EXIT>"
extr 063 002 19.0 0.5 # "<EXIT>"
extr 064 000 32.0 0.5 # "HONDA"
extr 065 000  7.0 0.5 # "BABY  ON  BOARD!"
extr 066 000  6.0 0.5 # "CAUTION  NO  WARNING SIGNS"
extr 067 000 23.0 0.5 # "Reebok" [rot90] [typeset-over]
extr 068 000  5.0 0.5 # "E" [calligraphic]
extr 068 001  6.0 0.5 # "LOBBY CONFERENCE ROOM"
extr 069 000  6.0 0.5 # "ELGIN"
extr 069 001  5.0 0.5 # "WELLINGTON"
extr 069 002  2.5 0.5 # "RUE  ST."
extr 069 003  2.3 0.5 # "RUE  ST."
extr 070 000 16.0 2.0 # "50's drive-in"
