#! /usr/bin/gawk -f
# Last edited on 2015-10-03 23:22:49 by stolfilocal

BEGIN \
  { 
    # Writes an STL description of an approximate
    # cylinder centered at the origin and rotating
    # about the Z axis, modeled as an antiprism.
    
    # User must define (with "-v") the number {N} of sides.
    if (N =="") { printf "** must define {N}\n" > "/dev/stderr"; exit(1); }
    
    minZ = -3.1415926;
    maxZ = +3.1415926;
    rad = 2.718281828;
    
    pi = 3.141592653589793238462;
    
    printf "solid\n";
    
    for (i = 0; i < N; i++)
      { # Compute {{x,y}[b][k]} of vertices {i+k} on each base {b}:
        split("", x);
        split("", y);
        for (k = 0; k < 2; k++)
          { for (b = -1; b <= +1; b += 2)
              { t = (i + k + 0.25*b) * 2*pi / N;
                x[b][k] = rad * cos(t);
                y[b][k] = rad * sin(t);
              }
          }
        
        # Write the two triangles: 
        write_triangle(x[-1][0],y[-1][0],minZ, x[-1][1],y[-1][1],minZ, x[+1][0],y[+1][0], maxZ);
        write_triangle(x[+1][1],y[+1][1],maxZ, x[+1][0],y[+1][0],maxZ, x[-1][1],y[-1][1], minZ);
        
      }
    
    printf "\n";
    printf "endsolid\n";
    
  }
        
function write_triangle \
  ( xa,ya,za, xb,yb,zb, xc,yc,zc, \
    xu,yu,zu, xv,yv,zv, xn,yn,zn, dn \
  )        
  {
    # Compute normal direction: 
    xu = xc - xb; yu = yc - yb; zu = zc - zb;
    xv = xa - xb; yv = ya - yb; zv = za - zb;
    xn = zu*yv - zv*yu;
    yn = xu*zv - xv*zu;
    zn = yu*xv - yv*xu;
    dn = sqrt(xn*xn + yn*yn + zn*zn);
    if (dn <= 1.0e-8) 
      { xn = 0; yn = 0; zn = 0; }
    else
      { xn /= dn; yn /= dn; zn /= dn; }
    
    printf "\n";
    printf "facet\n"
    printf "normal %+.6f %+.6f %+.6f\n", xn, yn, zn;
    printf "outer loop\n";
    printf "  vertex %10.5f %10.5f %10.5f\n", xa, ya, za;
    printf "  vertex %10.5f %10.5f %10.5f\n", xb, yb, zb;
    printf "  vertex %10.5f %10.5f %10.5f\n", xc, yc, zc;
    printf "endloop\n";
    printf "endfacet\n";
  }
    
    
