/* mtv_valve_backloop_make.h --- makes the backflow channel of a single Tesla valve. */
/* Last edited on 2016-04-03 19:55:24 by stolfilocal */

#ifndef mtv_valve_backloop_make_H
#define mtv_valve_backloop_make_H

#define _GNU_SOURCE
#include <stdio.h>
#include <stdint.h>

#include <bool.h>
#include <r3.h>
#include <r3_path.h>
#include <ppv_array.h>

void mtv_valve_backloop_make 
  ( ppv_array_t *a, 
    double inR,   /* Inner radius of main tube. */
    double otR,   /* Outer radius or main tube. */
    r3_path_state_t *bbS, /* State of main channel at beginning of untwisted backflow channel. */
    r3_path_state_t *beS, /* State of main channel at end of untwisted backflow channel. */
    double bfR,   /* Radius of backflow loop. */ 
    double trD,   /* Angle spanned by the turn of the backflow loop, before torsion. */
    double bmW,   /* Torsion angle of backflow loop at beginning of the turn. */
    double beW,   /* Torsion angle of backflow loop at end of the turn. */
    double fuzzR, /* Range of distance function. */
    bool_t sub,   /* FALSE to lay down the tubes, TRUE to clear out the hole. */
    r3_path_state_t *btS0, /* (OUT) State at beginning of backloop, with twist. */
    r3_path_state_t *btS1  /* (OUT) State at end of backflow loop,with twist. */
  );
  /* Splats the backflow channel of a Tesla valve (the hook-shaped tube)
    into the tomogram {a}. See {mtv_valve_segment_make} for a basic
    description of its geometry and of the parameters
    {inR,otR,bfR,trD,bmW,beW,fuzzR,sub}.
  
    The parameters {bbS} and {beS} should be the path states along the main channel
    where the backflow loop begins and ends.  See {mtv_valve_segment_main_make}
    for the specification of the orientation matrices {bbS.M} and {beS.M}.
    
    Basically, the loop it consists of two parts, the /stem/ and the /turn/, with
    midlines {stS} and {trS} with lengths {stL} and {trL} respectively,
    connected by a smooth /joint/.
    
    The turn's midline {trS} is traced by a point that follows an arc of
    a circle of radius {bfR} with total span {trD}, on a plane that
    turns around the line {K} that is tangent to the main channel
    midline {mcS} at state {beS}. The circle too is tangent to {mcS} at
    point {beP = beS.p}, and ends at that point when {t=bfL}. While the
    moving point traces that arc of circle, the plane of the circle
    sweeps from angle {bmW} to {beW} relative to the osculating plane of
    the main channel.
    
    The stem part {stS} of the midline {bfS} is a smooth Bezier arc that connects the
    point {bbP=bbS.p} to the start of of the turn.  
  */
  
#endif
