/* mtv_valve_helical_body_make.h --- makes the spiral Tesla valve proper. */
/* Last edited on 2016-04-22 18:51:43 by stolfilocal */

#ifndef mtv_valve_helical_body_make_H
#define mtv_valve_helical_body_make_H

#define _GNU_SOURCE
#include <stdio.h>
#include <stdint.h>

#include <bool.h>
#include <r3.h>
#include <r3_path.h>
#include <ppv_array.h>
  
void mtv_valve_helical_body_make
  ( ppv_array_t *a, 
    r3_t *ctr, 
    double hxbotZ, 
    double hxtopZ, 
    double helixN,  /* Number of turns of the helical part of main channel. */
    double helixR,  /* Radius of midline of helical part of main channel (vx). */
    int32_t stageN, /* Number of stages. */
    double mcA,     /* Nominal angular extent of each stage (rad). */
    double bfD,     /* Angular distance between ends of backflow loop (rad). */
    double bfR,     /* Radius of of final part (the turn) of the backflow loop (vx). */ 
    double bmW,     /* Torsion angle of backflow loop at beginning of the turn (rad). */
    double beW,     /* Torsion angle of backflow loop at end of the turn (rad). */
    double inR, 
    double otR, 
    double fuzzR, 
    bool_t sub,
    r3_path_state_t *vbS0, /* (OUT) State at beginning of helical tube. */
    r3_path_state_t *vbS1  /* (OUT) State at end of helical tube. */
  );
  /* Splats into the tomogram {a} the helical part of a multi-stage
    Tesla valve. The midline of the valve's main channel is a helix with
    radius {helixR}, that makes {helixN} turns around a vertical
    axis that goes through the point {ctr}, and spans from {Z=hxbotZ} to
    {Z=hxtopZ}.
    
    There are {stageN} stages in the whole helix, 
    spaced {mcA} radians apart in {XY} projection.  Each
    stage has a backflow loop with the specified shape parameters
    {bfR,bmW,beW} (see {mtv_valve_segment_make}), and its ends are 
    separated by an angle {bfD} when projected on the {XY} plane.
    
    The tubes have inner radius {inR} and outer radius {otR}. The
    distance function saturates at distance {fuzzR} from the surface.
    All dimensions are in multiples of the voxel size.
   
    The procedure also returns in {vbS0} and {vbS1} (if they are not NULL)
    the path states at the beginning and end of the main channel. In
    each state {S}, the position {S.p} is a point on the midline of the tube,
    and the orientation matrix {S.M} is an orthonormal frame. Vector {S.u} (row 0 of {S.M}) is a
    unit vector tangent to the tube's midline. Vector {S.v} (row 1 of {S.M}) points
    directly towards the axis of the helix; vectors {S.u} and {S.v} (rows 0 and 1 of {S.M}) span the
    osculating plane of the helix at that point. Then {S.w} (row 2 of {S.M}) is the
    normal of that plane and is somewhat tilted with respect to the
    helix axis.
    
    If {sub} is true, subtracts a wire that clears the hollows of the main channel and 
    any backflow loops. */

#endif
