/* mtv_valve_helical_connector_make.h --- makes start and finish tubes for a spiral Tesla valve. */
/* Last edited on 2016-04-21 21:30:29 by stolfilocal */

#ifndef mtv_valve_helical_connector_make_H
#define mtv_valve_helical_connector_make_H

#define _GNU_SOURCE
#include <stdio.h>
#include <stdint.h>

#include <bool.h>
#include <r3.h>
#include <r3_path.h>
#include <ppv_array.h>

void mtv_valve_helical_connector_make
  ( ppv_array_t *a, 
    r3_t *ctr, 
    r3_path_state_t *S,
    int dir,
    double endZ,
    double inR, 
    double otR, 
    double fuzzR,
    bool_t sub,
    r3_path_state_t *T /* (OUT) State at end of connecting tube. */
  );
  /* Splats a tube connecting the end of the helical part of the main
    channel (state {S}) to a point on the axis with {Z} coordinate
    {endZ}. 
    
    If {dir} is {+1}, assumes that {S} is at the top of the helical channel,
    with the {S.u} vector pointing out of the main channel.  If {dir} is {-1},
    assumes that {S} is at the bottom end of the helical channel, with {S.u}
    pointing into it.  In both cases, {T.u} will point towards {+Z}. */

#endif
