/* mtv_valve_helical_tubing_make.h --- tubings of s spiral chain of Tesla valves, including start and finish tubes. */
/* Last edited on 2016-04-22 18:53:26 by stolfilocal */

#ifndef mtv_valve_helical_tubing_make_H
#define mtv_valve_helical_tubing_make_H

#define _GNU_SOURCE
#include <stdio.h>
#include <stdint.h>

#include <bool.h>
#include <r3.h>
#include <r3_path.h>
#include <ppv_array.h>

void mtv_valve_helical_tubing_make
  ( ppv_array_t *a, 
    r3_t *ctr, 
    double tbbotZ, 
    double tbtopZ, 
    double helixN,  /* Number of turns of the helical part of main channel. */
    double helixR,  /* Radius of midline of helical part of main channel (vx). */
    int32_t stageN, /* Number of stages. */
    double mcA,     /* Nominal angular extent of each stage (rad). */
    double bfD,     /* Angular distance between ends of backflow loop (rad). */
    double bfR,     /* Radius of of final part (the turn) of the backflow loop (vx). */ 
    double bmW,     /* Torsion angle of backflow loop at beginning of the turn (rad). */
    double beW,     /* Torsion angle of backflow loop at end of the turn (rad). */
    double inR, 
    double otR, 
    double fuzzR,
    bool_t sub,
    r3_path_state_t *tbS0, /* (OUT) State at beginning of helical tube. */
    r3_path_state_t *tbS1  /* (OUT) State at end of helical tube. */
  );
  /* Same as {mtv_valve_helical_body_make}, except that it adds an extra
    length of tubing at each end of the main helical channel, so that its
    starts and ends on the helix axis, in a vertical direction.
    Therefore, the helical body proper spans only a part of the interval
    from {tbbotZ} to {tbtopZ}.
    
    The procedure returns in {tbS0,tbS1} the start and end
    of the connecting tubes. */

#endif
