/* Loop closure tools. */
/* Last edited on 2015-11-15 18:57:46 by stolfilocal */

#ifndef salamic_closer_H
#define salamic_closer_H

#define _GNU_SOURCE
#include <stdint.h>

#include <bool.h>

#include <stmesh.h>
#include <salamic_stats.h>

void salamic_closer_close
  ( stmesh_t mesh,
    int32_t pZ,
    uint32_t mf,
    stmesh_face_t f[], 
    char *closer, 
    char *outPrefix, 
    salamic_stats_t *st
  );
  /* Given a list {f[0..mf-1]} of faces (triangles) of
    the {mesh} that are intercepted by a slicing plane at quantized
    {Z}-coordinate {pZ}, computes the corresponding face-plane
    intersections, joins the resulting segments into one or more paths
    or closed loops, and writes them to a disk file. Uses the algorithm
    specified by {closer}.
    
    Allowed values of {closer} are
    
      | "TRIVIAL" - Trivial closure: exhastve look for matching endpoints. 
      | "STOLFI" - Stolfi's closure: uses edge numbers to find matching endpoints.
      
    ??? Maybe add "BENTLEY". ???
    ??? Maybe add "MINETTO". ???
    
    The procedure assumes that no vertex of the given rtiangles lies on
    the slicing plane, and that every face in {f} has three distinct
    vertices (even if they are collinear). 
    
    ??? Assumes circular sorting of faces ???
    
    ??? Loop orientation ???
    
    See {salamic_closer_output_file_name_INFO} below for the names of the
    output files, and {stmesh_section_format_INFO} for their format.

    Gathers runtime statistics in {st}. */

#define salamic_closer_output_file_name_INFO \
  "A separate file is written out for each slicing plane." \
  " The output files are called \"{OUTPREFIX}{SZZZ}.txt\" where" \
  " {OUTPREFIX} is the speficied output filename prefix, and {SZZZ} is " \
  " the quantized {Z}-coordinate of the slicing plane," \
  " with explicit sign \"+\" or \"-\" and ten digits, zero-padded."

#endif
