/* See {stmesh_view_GL.h} */
/* Last edited on 2015-11-18 01:02:36 by stolfilocal */

#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <values.h>
#include <assert.h>

#include <GL/glu.h>
#include <GL/glut.h>

#include <bool.h>

#include <stmesh_view_GL.h>

void stmesh_view_GL_initialize_libraries(int *argc, char** argv)
  { 
    glutInitWindowPosition(stmesh_view_GL_default_window_corner_H, stmesh_view_GL_default_window_corner_V);
    glutInitWindowSize(stmesh_view_GL_default_window_HSize, stmesh_view_GL_default_window_VSize);
    glutInit(argc, argv);
  }
  
void stmesh_view_GL_initialize_window
  ( char *title,
    void display(void),
    void reshape(int width, int height),
    void keyboard(unsigned char key, int x, int y),
    void passivemouse(int x, int y),
    void activemouse(int x, int y),
    void special(int key, int x, int y)
  )
  { 
    /* Setup window parameters: */
    glutInitDisplayMode(GLUT_RGB|GLUT_DEPTH|GLUT_DOUBLE);

    /* Create window: */
    bool_t success = glutCreateWindow(title);
    if (!success) 
      { fprintf(stderr, "Error opening main window\n"); exit(1); }

    /* Setup graphics modes: */
    glShadeModel(GL_FLAT);
    glEnable(GL_DEPTH_TEST);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    
    /* Which textures to use on the two sides of a surface: */
    glLightModeli(GL_LIGHT_MODEL_TWO_SIDE,1); /* Use the back texture on the back side. */
    
    /* Get line width choices: */
    GLfloat lwdRange[2];   /* Supported line width range. */
    GLfloat lwdStep;       /* Supported line width increments. */
    glGetFloatv(GL_LINE_WIDTH_RANGE, lwdRange);
    glGetFloatv(GL_LINE_WIDTH_GRANULARITY, &lwdStep);
    fprintf(stderr, "line width ranges from %.4f to %.4f in steps of %.4f\n", lwdRange[0], lwdRange[1], lwdStep);

    /* Register event handling methods: */
    glutKeyboardFunc(keyboard);
    glutMotionFunc(activemouse);
    glutPassiveMotionFunc(passivemouse);
    glutSpecialFunc(special);
    glutDisplayFunc(display);
    glutReshapeFunc(reshape);
  }
  
void stmesh_view_GL_start_viewing(void)
  { 
    /* Start displaying: */
    glutMainLoop();
  }

