#! /bin/bash
# Last edited on 2015-10-18 01:01:38 by stolfilocal

# Compares the output of two slicers or closers

pref1="$1"; shift;
pref2="$1"; shift;

echo "comparing the logs:" 1>&2
prdiff -Bb {${pref1},${pref2}}.log

for pref in ${pref1} ${pref2} ; do 
  ( cd out && ls ${pref}*.txt ) \
    | sed -e "s/^${pref}//g" -e "s/[.]txt//g" \
    | sort -b -k1,1g \
    > .${pref}.plz
done

echo "comparing Z coords of planes:" 1>&2
prdiff -Bb .{${pref1},${pref2}}.plz

ndiff=0;
if cmp -s .{${pref1},${pref2}}.plz ; then 
  # Compare one by one:
  for plz in `cat .${pref1}.plz` ; do
    tfile="out/${pref1}${plz}.txt";
    mfile="out/${pref2}${plz}.txt";
    if ! cmp -s ${tfile} ${mfile} ; then
      printf "%s comparing ${tfile} ${mfile} %s\n" "---" "---"
      prdiff -Bb ${tfile} ${mfile}
      ndiff=$(( ${ndiff} + 1 ));
      if [[ ${ndiff} -ge 3 ]]; then 
        echo "too many differences -- aborted" 1>&2
        exit 1;
      fi
      printf "\n"
    fi
  done
fi

