#! /bin/bash
# Last edited on 2016-12-13 20:29:54 by stolfilocal

# Runs {salamic_slice} on given arguments

# echo "args = ${*}"

modelDir="$1"; shift;    # Directory containing the model file.
modelName="$1"; shift;   # Model STL file name (without ".stl" extension).
modelFormat="$1"; shift; # Model STL file format ("ascii" or "binary")
nfGuess="$1"; shift;     # Guessed number of triangles. 
eps="$1"; shift;         # Quantization length unit (mm). 
spacing="$1"; shift;     # Type of slicing: "unif" or "adapt". 
if [[ "/${spacing}" == "/unif" ]]; then
  startZ="$1"; shift;      # Z-coord of initial slicing plane (mm). 
  deltaZ="$1"; shift;      # Z-spacing of slicing planes, if uniform (mm). 
  planeOps=( -startZ ${startZ} -deltaZ ${deltaZ} )
elif [[ "/${spacing}" == "/adapt" ]]; then 
  planeZFile="$1"; shift;  # Name of file with slicing plane {Z}-coords (mm). 
  planeOps=( -planeZFile in/${planeZFile}.txt )
else
  echo "** bad spacing option '${spacing}'" 1>&2 ; exit 1
fi
slicer="$1"; shift;      # Slicing method ("TRIVIAL" or "MINETTO"). 
closer="$1"; shift;      # Loop closing method ("TRIVIAL" or "STOLFI"). 

PROGDIR="../.."
PROG="salamic"

echo "modelDir = ${modelDir}" 1>&2
echo "modelName = ${modelName}" 1>&2
echo "modelFormat = ${modelFormat}" 1>&2
echo "nfGuess = ${nfGuess}" 1>&2
echo "eps = ${eps}" 1>&2
echo "spacing = ${spacing}" 1>&2
echo "startZ = ${startZ}" 1>&2
echo "deltaZ = ${deltaZ}" 1>&2
echo "planeZFile = ${planeZFile}" 1>&2
echo "slicer = ${slicer}" 1>&2
echo "closer = ${closer}" 1>&2

outPrefix="out/${modelName}-${spacing}-${slicer}-${closer}"

rm -f ${outPrefix}*.txt

${PROGDIR}/${PROG} \
    -eps ${eps} \
    ${planeOps[@]} \
    -modelFile ${modelDir}/${modelName}.stl \
    -format ${modelFormat} \
    -nfGuess ${nfGuess} \
    -slicer ${slicer} \
    -closer ${closer} \
    -outPrefix ${outPrefix} \
  2>&1 | tee ${outPrefix}.log
    
set +x
if [[ "/${spacing}" == "/adapt" ]]; then 
  # Get the slice files, if any:
  shopt -s nullglob
  slices=( ${outPrefix}*.txt )
  shopt -u nullglob
  printf "found %d slice files\n" "${#slices[@]}" 1>&2
  sliceOps=()
  for s in "${slices[@]}" ; do 
    sliceOps+=( -sliceFile "${s}" )
  done
  if [[ ${#sliceOps[@]} -gt 0 ]]; then
    # Show the slices on the model mesh:
    stmesh_view \
      -title "${modelName}" \
      -eps ${eps} \
      -format ${modelFormat} \
      -nfGuess ${nfGuess} \
      ${sliceOps[@]} \
      ${modelDir}/${modelName}.stl
  fi
fi
    
