#! /bin/bash
# Last edited on 2017-03-01 13:58:08 by stolfilocal

# echo "args = ${*}"

set -u

modelDir="$1"; shift;    # Directory containing the model file.
modelName="$1"; shift;   # Model STL file name (without ".stl" extension).
modelFormat="$1"; shift; # Model STL file format ("ascii" or "binary")
nfGuess="$1"; shift;     # Guessed number of triangles. 
eps="$1"; shift;         # Quantization length unit. 

PROGDIR=".."
PROG="stmesh_view"

# echo "modelDir = ${modelDir}" 1>&2
# echo "modelName = ${modelName}" 1>&2
# echo "modelFormat = ${modelFormat}" 1>&2
# echo "nfGuess = ${nfGuess}" 1>&2
# echo "eps = ${eps}" 1>&2

# Get the slice files, if any:
shopt -s nullglob
slice=( slices/${modelName}/slice*.txt )
shopt -u nullglob
printf "found %d slice files\n" "${#slice[@]}" 1>&2

sliceOps=()
for s in "${slice[@]}" ; do 
  sliceOps+=( -sliceFile "${s}" )
done

set -x

${PROGDIR}/${PROG} \
    -title "${modelName}" \
    -eps ${eps} \
    -format ${modelFormat} \
    -nfGuess ${nfGuess} \
    ${sliceOps[@]} \
    ${modelDir}/${modelName}.stl 
    
    
