/* Last edited on 2006-06-14 15:58:56 by stolfi */

typedef struct grade_t 
{ int N;          /* Numero de clulas em cada eixo. */
  int L;          /* Nmero de  da borda UMPL. */
  double **Xinf;  /* Parte inferior da borda na direcao X, {L x (N+1)}. */
  double **Xsup;  /* Parte superior da borda na direcao X, {L x (N+1)}. */
  double **Yinf;  /* Parte inferior da borda na direcao Y, {(N+1-2*L) x L}. */
  double **Ysup;  /* Parte superior da borda na direcao Y, {(N+1-2*L) x L}. */
  double c;       /* Constante que multiplica a matriz de fundo. */
  double **fundo; /* Matriz de fundo, {(N + 1) x (N + 1)}. */
} grade_t;
/* Descreve uma funo {M} amostrada numa grade discreta com {(N+1)x(N+1)} 
   pontos (os cantos de {N x N} clulas).  A grade consiste de uma borda com 
   {L} pontos de largura (armazenada separadamente nas matrizes{M.Xsup,M.Xinf,M.Ysup,M.Yinf}) e
   uma matriz de fundo (armazenados numa outra matriz com {(N+1)x(N+1)}). O valor da funo
   no ponto {(ix,jy)} (conceitualmente, o elemento {M[ix][jy]}) deve ser acessado 
   atraves da funo {mget(M,ix,jy)}. */

grade_t *cria_grade(int N, int L, double c, double **fundo);
/* Cria uma {grade_t} {M} com {(N + 1) x (N + 1)} pontos, consistindo
  de uma borda de largura {L} sobre a matriz {fundo} (que deve ter
  tamanho {(N+1)x(N+1)}) dividida pela constante {c}. */

double mget(grade_t *M, int ix, int jy);
/* Pega o valor armazenado no ponto {(ix,jy)} da grade {M}
  (conceitualmente, {M[ix][jy]}). Se esse ponto estiver na borda, ele
   obtido da matriz {M.Xsup}, {M.Xinf}, {M.Ysup}, ou {M.Yinf}, conforme o
  caso. Seno, ele  o elemento correspondente da matriz de fundo,
  {M.fundo[ix][jy]}, dividido pela constante {M.c}. */

void mset(grade_t *M, int ix, int jy, double valor);
/* Armazena {valor} no ponto {(ix,jy)} da grade {M} (conceitualmente,
  {M[ix][jy]}). Se esse ponto estiver na borda, ele  armazenado na
  matriz {M.Xsup}, {M.Xinf}, {M.Ysup}, ou {M.Yinf}, conforme o caso.
  Seno, a funo acusa um erro. */

double DerivAntSimet(grade_t *M, double dxy, int ix, int jy, int flag);
/* Deriva uma funo anti-simtrica, armazenada na grade M, com relaao a x e a y. 
   Se flag = 1 deriva com relao a x, se flag = 0 deriva com relao a y.*/

double DerivSimet(grade_t *M, double dxy, int ix, int jy, int flag);
/* Deriva uma funo simtrica, armazenada na grade M,  com relaao a x e a y. 
   Se flag = 1 deriva com relao a x, se flag = 0 deriva com relao a y. */

double** matrix_alloc(int nl, int nc);
/* Cria uma estrutura de matriz padro C, com {nl} linhas e {nc} colunas. */

FILE* abre_grafico(int n, double dx, double dy);
/* Executa o {gnuplot} e abre um canal para o mesmo. Incializa as escalas
  nos eixos X, Y, e Z de modo a cobrir o retngulo {[0 _ n*dx]  [0 _ n*dy]}.  */
  
void mostra_matriz
  ( FILE *pp, 
    char *tit, 
    double time, 
    int n, 
    double dx, 
    double dy,
    double dz,
    double **val,
    int espera
  );
/* Mostra a matriz {val} de tamanho {n} por {n}, usando o comando {splot} do {gnuplot}.
  Supe passos {dx} e {dy} nos eixos X e Y. 
  Acerta a escala em {Z} para o intervalo {[-dz _ +dz]}
  Usa o canal {pp} que deve ter sido criado com {abre_grafico}.
  Se {espera}   1, espera o usurio digitar ENTER antes de retornar. */

void mostra_grade
  ( FILE *pp, 
    char *tit, 
    double time, 
    int n, 
    double dx, 
    double dy, 
    double dz,
    grade_t *G, 
    double **val, 
    int espera
  );
/* Similar a {mostra_matriz}, mas copia os dados da grade {G} para a matriz {val} antes de mostrar. */

void fatal(char* s);
/* Aborta o programa com erro. */
