/* Cartesian 2D geometry */

#ifndef R2_H
#define R2_H

#include <vector>

using namespace std;

typedef struct R2_t {
  float x, y;
} R2_t; 
/* A point of {R 2}. */

int R2_hash (R2_t *v);
/* Maps a point {v} to an integer, pseudorandomly. */

typedef struct R2_Segment_t {
    R2_t v[2];
} R2_Segment_t;
/* A segment defined by two points of {R 2}. */

int R2_Segment_hash (R2_Segment_t *seg);
/* Maps a segment {seg} to an integer, pseudorandomly. */

typedef vector<R2_t> R2_Polygon_t;
/* A polygon is a list of vertices, which are points of {R 2}. */

#endif
