/* Unstructured triangle mesh where triangle vertices are {R3_t} points */

#ifndef R3_Mesh_H
#define R3_Mesh_H

using namespace std;

#include <vector>

#include "R2.h"
#include "R3.h"
/*
#include "glm/glm.hpp"
#include "glm/gtc/matrix_transform.hpp"
*/

typedef struct R3_Triangle_t {
    R3_t v[3], normal;
    float zMin, zMax;
} R3_Triangle_t;

R3_Triangle_t R3_Triangle_create(R3_t normal, R3_t v0, R3_t v1, R3_t v2);
/* Creates a triangle from the given fields. */

//  void R3_Trangle_transform(R3_triangle_t *t, const glm::mat4 *mat);

typedef std::vector<R3_Triangle_t> R3_Triangle_Vector_t;

typedef struct R3_Mesh_t {
  int meshSize;              /* Number of triangles. */
  R3_Triangle_Vector_t T;    /* The triangles. */
  bool sorted;               /* True if triangles are sorted by increasing {zMin} */
  R3_t vMin, vMax;           /* Bounding box corners. */
} R3_Mesh_t;

R2_t R3_Mesh_Side_slice(R3_t *vi, R3_t *vj, float Z);
/* Intersects the line {vi--vj} with a horizontal plane at the given {Z} coordinate.
  The line must not be horizontal. */

R2_Segment_t R3_Mesh_Triangle_slice(R3_Triangle_t *t, float Z);
/* Computes the intersection of a triangle {t} with an horizontal plane 
   with given {Z}-coordinate, yielding a segment on that plane.
   Assumes that the intersection is not empty. */

int stlToMeshInMemory(const char *stlFile, R3_Mesh_t *mesh, bool isBinaryFormat);
/* read the given STL file name (ascii or binary is set using ‘isBinaryFormat’)
   and generate a R3_Triangle_t Mesh object in output parameter ‘mesh’. */

/* DOUBLY LINKED LISTS OF TRIANGLES */


typedef struct R3_Mesh_Triangle_Node_t {
  R3_Triangle_t *t;
  struct R3_Mesh_Triangle_Node_t *next;
  struct R3_Mesh_Triangle_Node_t *prev;
} R3_Mesh_Triangle_Node_t;
/* Node of a ddoubly linked list of triangle pointers. */

typedef struct R3_Mesh_Triangle_List_t {
   R3_Mesh_Triangle_Node_t *head;
   R3_Mesh_Triangle_Node_t *tail;
} R3_Mesh_Triangle_List_t;
/* Header of a doubly linked list of triangle pointers. */

R3_Mesh_Triangle_List_t R3_Mesh_Triangle_List_create (void);
/* Creates the header of an enpty doubly linked list of triangles. */

void R3_Mesh_Triangle_List_insert (R3_Triangle_t *t, R3_Mesh_Triangle_List_t *l);
/* Inserts the triangle ponter {t} in the doubly linked list whose header is {*l}. */

void R3_Mesh_Triangle_List_union (R3_Mesh_Triangle_List_t *l1, R3_Mesh_Triangle_List_t *l2);
/* Appends all nodes of the doubly linked list whose header is {*l2} to the list whose header is {*l1},
   making {*l2} empty. */

void R3_Mesh_Triangle_List_remove (R3_Mesh_Triangle_List_t *l, R3_Mesh_Triangle_Node_t *node);
/* Removes the node {node} from the doubly linked list whose header is {*l}. */

#endif
