/* See {R3_SangSlicing.h} */

#include "R2.h"
#include "R3.h"
#include "R3_Slicer.h"
#include "R3_Mesh.h"

void R3_SangSlicing_slice (const R3_Mesh_t *mesh, vector<float> P, R3_Closure_Proc_t closer) {

    const vector<R3_Triangle_t> &v = mesh->getvTriangle();
    
    nplanes = P.size();
    
    #ifdef USE_CGAL
       vector<Segment_2> segs[P.size()];
    #else
       vector<sweep_point> segs[P.size()];
    #endif

    /*Slicing:*/
    for (size_t p = 0; p < P.size(); p++) {               
        segs[p].reserve (v.size());
        plane.setDistance(P[p]);        					
        long int id = 0; 
        /*For each triangle in the mesh: */
        for (auto it = v.begin(), itEnd = v.end(); it != itEnd; ++it) {                   
            const R3_Triangle_t triangle = *it; /* Current triangle. */
            R2_Segment_t ls;
            /* Does the plane intersect the triangle?: */
            if (triangle.intersectPlane(plane, ls) == 0) {
                if (ls.v[0].distTo(ls.v[1]) > 0.0001) {
                    sweep_point spa = {ls.v[0], ls.v[1], id}; 
                    sweep_point spb = {ls.v[1], ls.v[0], id};
                    #ifdef USE_CGAL 
                      segs[p].push_back(Segment_2(Point_2(ls.v[0].x, ls.v[0].y), Point_2(ls.v[1].x, ls.v[1].y)));
                    #else
                      segs[p].push_back(spa);
                      segs[p].push_back(spb);
                    #endif
                    id++;
                }
                intersections++;
            }
        }
    }
    clock_t slice_end = clock();
    timeslice = double(slice_end - slice_begin)/CLOCKS_PER_SEC;

    /*Loop-closure:*/
    clock_t contour_begin = clock();
    for (size_t p = 0; p < P.size(); p++) { 
        vector<R2_Segment_t> contour;              
        #ifdef USE_CGAL
            std::list<Point_2> pts;
            CGAL::compute_intersection_points (segs[p].begin(), segs[p].end(), std::back_inserter(pts), true);
            pts.clear();
            segs[p].clear();
        #else
            std::sort(segs[p].begin(), segs[p].end(), spcompare);
            /*if (segs[p].size() != 0) {
               sweep_point act = *segs[p].begin();
               //segs[p].erase(segs[p].begin());
               bool seen[segs[p].size()];
               for (int i = 0; i < segs[p].size(); i++) { seen[i] = false; }                
               seen[0] = true;
               for (auto it = segs[p].begin(), itEnd = segs[p].end(); (it != itEnd); ++it) {                  
                  size_t left = 0;
                  size_t right = segs[p].size();
                  while (left <= right) {
                     size_t mid = (left + right)/2;
                     if ((mid < 0) || (mid >= segs[p].size())) { break; }  
                     sweep_point tmp = segs[p].at(mid);
                     if (spfind(tmp,act) && (seen[mid] == false)) {
                        R2_Segment_t ls (act.p1, tmp.p2);
                        contour.push_back(ls);
                        seen[mid] = true;
                        //segs[p].erase(segs[p].begin() + mid);
                        act.p1 = tmp.p2;
                        act.p2 = tmp.p1;
                        act.id = tmp.id; 
                        break;
                     }
                     else if (act.p1.x > tmp.p1.x) {
                        left = mid + 1;
                     }
                     else if (act.p1.x < tmp.p1.x) {
                        right = mid - 1;
                        //cout << "nova dir: " << right << endl;
                     }
                     else {
                        if ((act.p1.x == tmp.p1.x) && (act.p1.y == tmp.p1.y) && (act.id == tmp.id)) {
                           if ((mid+1) < segs[p].size()) {
                              sweep_point tmp1 = segs[p].at(mid+1);
                              if ((act.p1.x == tmp1.p1.x) && (act.p1.y == tmp1.p1.y) && (act.id != tmp1.id)) {
                                 R2_Segment_t ls (act.p1, tmp1.p2);
                                 contour.push_back(ls);
                                 seen[mid+1] = true;
                                 //segs[p].erase(segs[p].begin() + (mid+1));
                                 //cout << "IGUAL (" << act.p1 << ", " << act.p2 << ", " << act.id << ") <-> (" << tmp1.p1 << ", " << tmp1.p2 << ", " << tmp1.id << ")" << endl;
                                 act.p1 = tmp1.p2;
                                 act.p2 = tmp1.p1;
                                 act.id = tmp1.id; 
                                 break;
                              } 
                           }
                           else if ((mid-1) >= 0) {
                              sweep_point tmp2 = segs[p].at(mid-1);
                              if ((act.p1.x == tmp2.p1.x) && (act.p1.y == tmp2.p1.y) && (act.id != tmp2.id)) {
                                 R2_Segment_t ls (act.p1, tmp2.p2);
                                 contour.push_back(ls);
                                 seen[mid-1] = true;
                                 //cout << "IGUAL (" << act.p1 << ", " << act.p2 << ", " << act.id << ") <-> (" << tmp2.p1 << ", " << tmp2.p2 << ", " << tmp2.id << ")" << endl;
                                 act.p1 = tmp2.p2;
                                 act.p2 = tmp2.p1;
                                 act.id = tmp2.id; 
                                 break;
                              }
                           }
                        }
                        //printf("Nem maior nem menor\n\n");
                        if (act.p1.y > tmp.p1.y) {
                           left = mid + 1;
                           //cout << "*ova esq: " << left << endl;
                        }
                        else {
                           right = mid - 1;
                           //cout << "*ova dir: " << right << endl;
                        }
                     } 
                     //left++;
                  }
               }
            }*/
            for (auto it = segs[p].begin(), itEnd = segs[p].end(); (it != itEnd); ++it) {                   
                sweep_point act = *it;
                sweep_point nxt = *(it+1);
                if (next(it,1) != itEnd) {
                    if ( (act.p1.x == nxt.p1.x) && (act.p1.y == nxt.p1.y) && (act.id != nxt.id) ) {
                        R2_Segment_t ls (act.p1, act.p2);
                        contour.push_back(ls);
                        segs[p].erase(it);
                    }
                }
            }
        #endif
        polygons.push_back(contour); 
    }
    clock_t contour_end = clock();
    timecontour = double(contour_end - contour_begin)/CLOCKS_PER_SEC;

    return 0;
}
