/* See {R3_TrivialSlicing.h} */

using namespace std;

#include <stdlib.h>

#include "R3.h"
#include "R2.h"
#include "R3_Mesh.h"
#include "R3_Slicer.h"
#include "R3_TrivialSlicing.h"

void R3_TrivialSlicing_slice (R3_Mesh_t *mesh, vector<float> P, R3_Closure_Proc_t *closer) {

  R3_Triangle_Vector_t *T = &(mesh->T);

  vector<R2_Segment_t> segs;

  /* Enumerate the slicing planes: */
  for (int p = 0; p < P.size(); p++) {               
    segs.clear();
    /* Enumerate all triangles of the mesh:*/
    for (R3_Triangle_Vector_t::iterator it = T->begin(), itEnd = T->end(); it != itEnd; ++it) {                   
      R3_Triangle_t *t = &(*it); /*Current triangle.*/
      /*Does the plane intersect the triangle?:*/
      if ((t->zMin < P[p]) && (t->zMax > P[p])) {
        /* Compute and save the intersection: */
        R2_Segment_t seg = R3_Mesh_Triangle_slice(t, P[p]);
        segs.push_back(seg);
      }
    }
    if (closer != NULL) { 
      /* Process the segments: */
      closer(mesh, P[p], &segs);
    }
  }
}
