/* Trivial slicing of an {R3_Mesh_t}. */

#ifndef R3_TrivialSlicing_H
#define R3_TrivialSlicing_H

#include "R3.h"
#include "R2.h"
#include "R3_Mesh.h"
#include "R3_Slicer.h"

void R3_TrivialSlicing_slice (R3_Mesh_t *mesh, vector<float> P, R3_Closure_Proc_t *closer);
/* Slices an unstructured mesh {mesh} by a list of horizontal planes, defined
   by their Z-coordinates {P[0..k-1]}. If the {closer} procedure is not empty,
   calls {closer(P[i],segs)} for each plane, where {segs} is the unordered
   list of intersections of that plane with all mesh triangles. */

#endif
