#! /bin/bash

set verbose

g++ -c Utils.h Utils.cpp
g++ -c R2.h R2.cpp
g++ -c R3.h R3.cpp
g++ -c R3_Mesh.h R3_Mesh.cpp
g++ -c R3_Slicer.h 

g++ -c R3_TrivialSlicing.h R3_TrivialSlicing.cpp
g++ -c R3_IncrementalSlicing.h R3_IncrementalSlicing.cpp

g++ -c R2_TrivialClosure.h R2_TrivialClosure.cpp

# g++ -c R3_SangSlicing.h R3_SangSlicing.cpp


g++ -c -std=c++11 SliceMain.cpp

g++ -O3 -std=c++11 -o SliceMain \
  SliceMain.cpp R2_TrivialClosure.cpp R3_IncrementalSlicing.cpp \
  R3_TrivialSlicing.cpp R3_Mesh.cpp R3.cpp R2.cpp Utils.cpp \
  tinyxml2.cpp Timer.cpp -fpermissive -lCGAL -frounding-math

time ./SliceMain -model models/01.bottle.stl; 

exit 0

video=video;

#rm *.svg;

rm ${video}/*;

#time ./intersectSorted -sang -model models/Allsoldier.stl -slicesize 0.032 
#time ./intersectSorted -trivial -model models/Allsoldier.stl -slicesize 0.032 
#time ./intersectSorted -stolfi -model models/Allsoldier.stl -slicesize 0.032 
#time ./intersectSorted -huang -model models/Allsoldier.stl -slicesize 0.032 

#01.bottle.stl  02.chassis.stl  03.mouse.stl  04.liver.stl  05.femur.stl  06.eiffel.stl  07.pump.stl  08.bunny.stl  09.stick.stl  10.demon.stl  11.rider.stl  12.sphere.stl  13.soldier.stl  14.warrior.stl  15.robot.stl  16.skull.stl

time ./intersectSorted -stolfi -model models/01.bottle.stl -slicesize 3.0; 
#time ./intersectSorted -stolfi -model models/06.eiffel.stl -slicesize 1.0; 
#time ./intersectSorted -stolfi -model models/08.bunny.stl -slicesize 3.0; 
#time ./intersectSorted -stolfi -model models/14.warrior.stl -slicesize 1.0; 
#time ./intersectSorted -stolfi -model models/13.soldier.stl -slicesize 2.0; 


#time ./intersectSorted -sang -model models/abottle.stl -slicesize 6.0; 
#time ./intersectSorted -huang -model models/abottle.stl -slicesize 6.0; 
#time ./intersectSorted -huang -model models/eiffeltower.STL -slicesize 6.0; 

./video.sh;
