int Huang (const R3_Mesh_t *mesh, vector<vector<R2_Segment_t> > &slicesWithLineSegs, const float sliceSize, vector<float> P) 
{
    long timeIni = Timer::getTimeMs();

    R3_Plane_t plane; /* The intersection plane. */

    plane.setNormal(R3_t(0, 0, 1)); /* Normal does not change during slicing. */

    //const multiset<R3_Triangle_t,R3_Triangle_Comparer_t> &m = mesh->getMesh(); /* Get a const handle to the input mesh. */

    const vector<R3_Triangle_t> &v = mesh->getvTriangle();

    double model_zmin = mesh->getBottomLeftVertex().z; /* Minimal z coordinate of the model. */ 

    vector<PointMesh> segments (P.size());

    //nplanes = no_P;

    //int falhou = 0;

    /* For each triangle in the mesh: */
    //for (auto it = m.begin(), itEnd = m.end(); it != itEnd; ++it) {                   
    for (auto it = v.begin(), itEnd = v.end(); it != itEnd; ++it) {                   

         /* Current triangle: */
         const R3_Triangle_t triangle = *it;

         //cout << "zmin: " << triangle.zMin << ", zmax: " << triangle.zMax << endl; 

         R2_Segment_t ls;

         int iplane_min = ceilf  (round ((triangle.zMin - model_zmin)/sliceSize * 100.0) / 100.0);

         int iplane_max = floorf (round ((triangle.zMax - model_zmin)/sliceSize * 100.0) / 100.0);

         while (iplane_min <= iplane_max) { 

             plane.setDistance(P[iplane_min]);

             /* Does the plane intersect the triangle?: */
             if (triangle.intersectPlane(plane, ls) == 0) {

                 intersections++;
                 
                 if (ls.v[0].distTo(ls.v[1]) > 0.0001) {
                     /* Adding the intersection in the Hash: */
                     (segments[iplane_min][ls.v[0]]).push_back(ls.v[1]);
                     (segments[iplane_min][ls.v[1]]).push_back(ls.v[0]);
                 }

             }
             /*if ((P[iplane_min] < triangle.zMin) || (P[iplane_min] > triangle.zMax)) {
                cout << "zmin: " << triangle.zMin << ", zmax: " << triangle.zMax << ", plane: " << P[iplane_min] << endl;
                falhou++;
             }*/  
             iplane_min++;
         } 
    }
    long timeEnd = Timer::getTimeMs();

    timeSlice += timeEnd - timeIni;

    /*Assembling polygons after slicing: */
    timeIni = Timer::getTimeMs();
    for (int i = 0; i < segments.size(); ++i) {
        plane.setDistance(P[i]);
        if (!segments[i].empty()) {
            slicesWithLineSegs.push_back(getSliceMinetto(plane, segments[i]));
        }
    }
    timeEnd = Timer::getTimeMs();
    timeContour = timeEnd - timeIni;
    //cout << "Falhou: " << falhou << endl;
    return 0;
}

