
/* See {R2.h} */

#include <math.h>
/*
#include "glm/glm.hpp"
#include "glm/gtc/matrix_transform.hpp"
*/

#include "R2.h"
#include "Utils.h"

int R2_hash (R2_t *v) {
  int h = 0;
  Utils_hash_combine(&h, Utils_float_hash(v->x));
  Utils_hash_combine(&h, Utils_float_hash(v->y));
  return h;
}

int R2_Segment_hash (R2_Segment_t *seg) {
  int h = 0;
  Utils_hash_combine(&h, R2_hash(&(seg->v[0])));
  Utils_hash_combine(&h, R2_hash(&(seg->v[1])));
  return h;
}
