/* See {R2_TrivialClosure.h} */

using namespace std;

#include <math.h>
#include <assert.h>

#include "R2.h"
#include "R2_TrivialClosure.h"

R2_t R2_TrivialClosure_find(vector<R2_Segment_t> *segs, R2_t u);
/* Looks in {segs} for a segment with one of the endpoints equel to {u}.
  If finds one, erases that segment, and returns the other endpoint.
  If does not find one, returns a point at infinity. */

R2_t R2_TrivialClosure_find(vector<R2_Segment_t> *segs, R2_t u) {
  for (vector<R2_Segment_t>::iterator j = segs->begin(); j != segs->end(); ++j) {
    R2_t v0 = j->v[0];
    R2_t v1 = j->v[1];
    if ((v0.x == u.x) && (v0.y == u.y)) {
      segs->erase(j);
      return v1;
    } else if ((v1.x == u.x) && (v1.y == u.y)) {
      segs->erase(j);
      return v0;
    }
  }
}

void R2_TrivialClosure_close(vector<R2_Segment_t> *segs, vector<R2_Polygon_t> *loops) {
  loops->clear();
  while (segs->size() > 0) {

    /* Get another contour: */
    R2_Polygon_t contour; 
  
    /* Get the first segment: */
    R2_t last;
    R2_t current;
    R2_t prev;
    { 
      vector<R2_Segment_t>::iterator i = segs->begin();
      last = i->v[0];
      current = i->v[1];
      contour.push_back(current);
      prev = last;
      segs->erase(i);
    }

    /* Get additional segments until loop is closed: */
    do {
      /* Find and delete another segment with endpoint {current}, advance {prev,current} */
      R2_t next = R2_TrivialClosure_find(segs, current);
      if ((next.x == +INFINITY) || (next.y == +INFINITY)) { 
	/* Open contour?! */
	assert(false);
      }
      assert((next.x != prev.x) || (next.y != prev.y));
      prev = current;
      current = next;
      contour.push_back(current);
    } while ((current.x != last.x) || (current.y != last.y));
    loops->push_back(contour);
  }
}


