
/* See {R3.h} */

#include <math.h>
/*
#include "glm/glm.hpp"
#include "glm/gtc/matrix_transform.hpp"
*/
#include "R3.h"
#include "Utils.h"

int R3_hash (const R3_t *v) {
  int h = 0;
  Utils_hash_combine(&h, Utils_float_hash(v->x));
  Utils_hash_combine(&h, Utils_float_hash(v->y));
  Utils_hash_combine(&h, Utils_float_hash(v->z));
  return h;
};


/*
R3_read(string label) {
  
		istringstream ss(label);
		string coord;
		getline(ss, coord, '|');
		x = atof(coord.c_str());
		getline(ss, coord, '|');
		y = atof(coord.c_str());
		getline(ss, coord, '|');
		z = atof(coord.c_str());
	}

    bool seen;
    

	void setCoords(array<float,3> a) {
		x = a[0]; y = a[1]; z = a[2];
	}
	void setCoords(string label) {
		istringstream ss(label);
		string coord;
		getline(ss, coord, '|');
		x = atof(coord.c_str());
		getline(ss, coord, '|');
		y = atof(coord.c_str());
		getline(ss, coord, '|');
		z = atof(coord.c_str());
	}
        void set_seen (bool value) {
           seen = value;
        }

	array<float,3> getCoords() { array<float,3> c = {{x, y, z}}; return c; }
    float dotproduct(const R3_t &v) const { return (x*v.x + y*v.y + z*v.z); }

float R3_distTo(const R3_t *a, const R3_t *b) {
  float dx = a->x - b->x;
  float dy = a->y - b->y;
  float dz = a->z - b->z;
  return sqrt(dx*dx + dy*dy + dz*dz); 
}

void transform(R3_t *v, const glm::mat4 *mat) { 
  glm::vec4 v4 = glm::vec4(v->x, v->y, v->z, 1.0);
  glm::vec4 vt = (*mat)*v4; 
  v->x = vt.x; v->y = vt.y; v->z = vt.z;
  }
*/

/*
    R3_t& operator-=(const R3_t &pt) { x= (x-pt.x); y=(y-pt.y); z=(z-pt.z); return *this;    }
    R3_t operator-(const R3_t &pt) { return R3_t((x-pt.x), (y-pt.y), (z-pt.z)); }
    R3_t operator+(const R3_t &pt) { return R3_t((x+pt.x), (y+pt.y), (z+pt.z)); }
    R3_t operator/(float a) { return R3_t((x/a), (y/a), (z/a)); }
    R3_t operator*(float a) { return R3_t((x*a), (y*a), (z*a)); }
	bool operator<(const R3_t &pt) const { return z < pt.z; }
	bool operator>(const R3_t &pt) const { return z > pt.z; }
	//bool operator==(const R3_t &pt) {return compf(x, pt.x) && compf(y, pt.y) && compf(z, pt.z); }
	bool operator==(const R3_t &pt) const {return distTo(pt) < 0.005; }
	//bool operator!=(const R3_t &pt) {return !(compf(x, pt.x) && compf(y, pt.y) && compf(z, pt.z)); }
	bool operator!=(const R3_t &pt) const { return distTo(pt) > 0.005; }
    float normalize() const { return sqrt(x*x+y*y+z*z); }
	string getLabel() const {
		stringstream ss;
		ss << roundIt(x) << "|" << roundIt(y) << "|" << roundIt(z);
		//ss << x << "|" << y << "|" << z;
		return ss.str();
	}
R3_t operator-(const R3_t &a, const R3_t &b) {return R3_t((a.x-b.x), (a.y-b.y), (a.z-b.z)); }
R3_t operator+(const R3_t &a, const R3_t &b) {return R3_t((a.x+b.x), (a.y+b.y), (a.z+b.z)); }

ostream& operator<<(ostream& os, const R3_t& v) {
		os << "x: " << v.x << "; y: " << v.y << "; z: " << v.z;
		return os;
	}

class R3_Plane_t {
public:
    R3_Plane_t() : mDistance(0) {}
    float distance() const { return mDistance; }
    float distanceToPoint(const R3_t &vertex) const {    return vertex.dotproduct(mNormal) - mDistance; }
    void setNormal(R3_t normal) { mNormal = normal; }
    void setDistance(float distance) { mDistance = distance; }
protected:
    R3_t        mNormal;    // normalized Normal-Vector of the plane
    float   mDistance;  // shortest distance from plane to Origin
};
*/

/*
public:
    R3_Segment_t(R3_t p0=R3_t(), R3_t p1=R3_t(), int l=0) { v[0]=p0; v[1]=p1; label=l; }
    int label;
	bool operator==(const R3_Segment_t &ls) const { return v[0] == ls.v[0] && v[1] == ls.v[1]; }
	int interceptPlane(R3_Plane_t &plane, R3_t &point) {
        R3_t a = v[0];
		R3_t b = v[1];
		const float da = plane.distanceToPoint(a);
        const float db = plane.distanceToPoint(b);
        if (da*db<0) {
            const float s = da/(da-db); // intersection factor (between 0 and 1)
            R3_t bMinusa = b-a;
            point = a+bMinusa*s;
			return 0;
        }
        else if (0==da) { // plane falls exactly on one of the three Triangle vertices
            point = a;
			return 0;
        }
        else if (0==db) { // plane falls exactly on one of the three Triangle vertices
            point = b;
			return 0;
        }
		return 0;
	}
	
	friend ostream& operator<<(ostream& os, const R3_Segment_t& ls) {
		os << "V0: (" << ls.v[0] << "); V1: (" << ls.v[1] << ")"	;
		return os;
	}
*/


