
#include "tinyxml2.h"
#include <fstream>
#include <string>
#include <vector>
#include <cmath>
#include <ctime>
// #include <chrono>
#include <iostream>
#include <set>
#include <cstdlib>
#include <unordered_map>
#include <sstream>
#include <iomanip>
#include <limits>
#include <array>
#include <algorithm>
#include <stdexcept>
#include <regex>
#include <map>
#include "simple_svg_1.0.0.hpp"
#include "Timer.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <algorithm>
#include <list>
#include <CGAL/Cartesian.h>
#include <CGAL/MP_Float.h>
#include <CGAL/Quotient.h>
#include <CGAL/Arr_segment_traits_2.h>
#include <CGAL/Sweep_line_2_algorithms.h>

#include "R3.h"
#include "R3_Mesh.h"
#include "R2.h"
#include "R2_LoopClosure.h"
#include "R3_TrivialSlicing.h"
#include "R3_IncrementalSlicing.h"

#define GLM_FORCE_RADIANS

#include "glm/glm.hpp"
#include "glm/gtc/matrix_transform.hpp"
#include "glm/gtc/type_ptr.hpp"
#include "glm/gtx/vector_angle.hpp"

#define DEG_TO_RAD(x) (x*0.0174532925199f)

#define FILE_STL_BIN 0
#define FILE_STL_ASCII 1
#define FILE_AMF_ASCII 2

using namespace std;
using namespace svg;
using namespace tinyxml2;

typedef CGAL::Quotient<CGAL::MP_Float>                  NT;
typedef CGAL::Cartesian<NT>                             Kernel;
typedef Kernel::Point_2                                 Point_2;
typedef CGAL::Arr_segment_traits_2<Kernel>              Traits_2;
typedef Traits_2::Curve_2                               Segment_2;

long visits = 0, intersections = 0;
//chrono::milliseconds timeBuild, timeSlice, timeContour, timeTotal;
long timeBuild=0, timeSlice=0, timeContour =0, timeTotal = 0, timeSort = 0;
double timeslice = 0.0, timecontour = 0.0;
size_t nplanes = 0;

bool sort_triangles;

bool compf(float a, float b, float epsilon = 0.0001) {
  const float absA = fabs(a);
  const float absB = fabs(b);
  const float diff = fabs(a - b);
	
  if (a == b)
    return true;
  else if (0 == a || 0 == b || diff < numeric_limits<float>::epsilon())
    return diff < (epsilon * numeric_limits<float>::epsilon());
  else
    return diff / (absA + absB) < epsilon;
}

//  bool compArray(const array<float,3> &a, const array<float,3> &b) {
//  	return compf(a[0], b[0]) && compf(a[1], b[1]) && compf(a[2], b[2]);
//  }

//  namespace std
//  {
//    template<typename T, size_t N>
//    struct hash<array<T, N> >
//    {
//      typedef array<T, N> argument_type;
//      typedef size_t result_type;
//  
//      result_type operator()(const argument_type& a) const
//      {
//        hash<T> hasher;
//        result_type h = 0;
//        for (result_type i = 0; i < N; ++i)
//  	{
//  	  h = h * 31 + hasher(a[i]);
//  	}
//        return roundIt(h);
//      }
//    };
//  }
//  
//  


// typedef unordered_map<R2_Segment_t, vector<R2_Segment_t>, Hasher> LineMesh;
// typedef unordered_map<R3_t, vector<R3_t>, HashV3> PointMesh;

// typedef unordered_map<R3_t, bool, HashV3> pHash;

void swap(R3_t &a, R3_t &b) {
    R3_t temp = a;
    a = b;
    b = temp;
} 

// void sort3Points(R3_t &a, R3_t &b, R3_t &c) {
// 	if (a > b) swap(a, b);
// 	if (a > c) swap(a, c);
// 	if (b > c) swap(b, c); 
// }
// 


// typedef map<float, tVector> zMaxTriangleMap;
// typedef map<float, zMaxTriangleMap> zMinTriangleMap;

// vector<R2_Segment_t> getSlice(R3_Plane_t &plane, PointMesh &segments) {
// 	PointMesh::iterator segIt;
// 	vector <R2_Segment_t> slice;
// 	R3_t origin, p1, p2;
// 	//clock_t timeIni = 0, timeEnd = 0;
// 
// 	long timeIni = Timer::getTimeMs();
//     //timeIni = clock();
//     //auto timeIni = chrono::high_resolution_clock::now();
// 	while (!segments.empty()) {
// 		auto segIt = segments.begin();
// 		origin = p1 = (*segIt).first;
// 		//cout << "begin: "<< p1 << endl;
// 		vector<R3_t> pVec = (*segIt).second;	
// 		p2 = pVec.at(0);
// 
// 		if (p1 != p2) {
// 			R2_Segment_t ls(p1, p2);
// 			slice.push_back(ls);
// 		}
// 		
// 		segments.erase(segIt);
// 		
// 		size_t countl = segments.count(p2);
// 
// 		while (countl && 2 == segments[p2].size()) {
// 			p1 = p2;
// 						
// 			if (segments[p1].at(0) == origin && 2 == segments[p1].size())
// 				p2 = segments[p1].at(1);
// 			else
// 				p2 = segments[p1].at(0);
// 
// 			if (p1 != p2) {
// 				R2_Segment_t ls(p1, p2);
// 				slice.push_back(ls);
// 			}
// 			origin = p1;
// 			segments.erase(p1);
// 			countl = segments.count(p2);
// 		}
// 	}
// 
// 	long timeEnd = Timer::getTimeMs();
//     //timeEnd = clock();
//     //auto timeEnd = chrono::high_resolution_clock::now();
// 	timeContour += timeEnd - timeIni;
// 	//timeContour += chrono::duration_cast<chrono::milliseconds>(timeEnd - timeIni);
// 	
// 	return slice;
// }
 
// R3_t findNearest(R3_t &act, PointMesh &segments) {
//     float distance = 1e6;
//     R3_t nearest = act;
//     
//     for (auto segment : segments) {
//         if (act.distTo(segment.first) < distance && act != segment.first) {
//             distance = act.distTo(segment.first);
//             nearest = segment.first;
//         }
//     }
//     //cout << "Nearest is: " << nearest << endl;
//     return nearest;
// }

// bool conquer (vector<R2_Segment_t>& slice, R3_t prev, R3_t act, R3_t head, PointMesh &segments, int label, pHash &seen) {
//     bool conquered = false;
//     bool s1 = false, s2 = false;
//     if ((act != head) ) {
//         if (segments[act].size() == 2) {
//             R3_t p1 = segments[act].at(0);
//             R3_t p2 = segments[act].at(1);
// 
//             if ((p1 != prev) ) {
//                 //cout << "->link: " << act << " " << p1 << endl;
//                 R2_Segment_t ls (act, p1, label);
//                 slice.push_back(ls);
//                 s1 = conquer (slice, act, p1, head, segments, label, seen);
//             }
//             else if ((p2 != prev) ) {
//                 //cout << "->link: " << act << " " << p2 << endl;
//                 R2_Segment_t ls (act, p2, label);
//                 slice.push_back(ls);
//                 s2 = conquer (slice, act, p2, head, segments, label, seen);
//             }
//         }
//     } else { conquered = true; }
//     
//     segments.erase(act);
//     
//     return (s1 || s2 || conquered);
// }

//  vector<R2_Segment_t> getSliceMinetto (R3_Plane_t &plane, PointMesh &segments) {
//      //clock_t timeIni, timeEnd;
//      //long timeIni = Timer::getTimeMs();
//      //timeIni = clock();
//      //auto timeIni = chrono::high_resolution_clock::now();
//      vector <R2_Segment_t> slice;
//      //vector<vector<R3_t>> polygons;
//  
//      pHash seen;
//  
//      int label = 1;
//  
//      while (!segments.empty()) {
//          auto it = segments.begin();
//          R3_t p1 = (*it).first;
//          R3_t head = p1;
//  
//          vector<R3_t> pVec = (*it).second;
//          segments.erase(it);
//  
//          bool status = false;
//          for (int k = 0; (k < pVec.size() && !segments.empty() && status == false); k++) {
//              R3_t p2 = pVec.at(k);
//              R2_Segment_t ls (p1, p2, label);
//              //polygons.at(label).push_back(p1);
//              //cout << "pvec: " << pVec.size() << " empty " << segments.empty() << endl;
//              //cout << "link: " << p1 << " " << p2 << endl;
//              slice.push_back(ls);
//              status = conquer (slice, p1, p2, head, segments, label, seen);
//              //if (!conquer (slice, p1, p2, head, segments, label, seen) && !segments.empty()) {
//                 // cout << "Before: p1: " << p1 << " " << "p2: " << p2 << endl;
//                  //R3_t aux = findNearest(p2, segments);
//                  //p1 = p2;
//                  //p2 = aux;
//                  //cout << "After: p1: " << p1 << " " << "p2: " << p2 << endl;
//              //} else {
//                  label++;
//              //}
//          }
//      }
//  
//      //cout << "Labels: " << label << endl;
//      //long timeEnd = Timer::getTimeMs();
//      //timeEnd = clock();
//      //auto timeEnd = chrono::high_resolution_clock::now();
//      //timeContour += chrono::duration_cast<chrono::milliseconds>(timeEnd - timeIni);
//      //timeContour += timeEnd - timeIni;
//      return slice;
//  }


//#define USE_CGAL

typedef struct _sweeplane {
   R3_t p1;
   R3_t p2;
   long int id;
} sweep_point;

bool spcompare (sweep_point t1, sweep_point t2) {
   if (t1.p1.x == t2.p1.x) { return t1.p1.y < t2.p1.y; }
   else { return t1.p1.x < t2.p1.x; }
}

bool spfind (sweep_point t1, sweep_point t2) {
   if ((t1.p1.x == t2.p1.x) && (t1.p1.y == t2.p1.y) && (t1.id != t2.id)) { return true; }
   else { return false; }
}


#define ERROR -1

vector<float> compute_P (const R3_Mesh_t *mesh, float delta, float deltaMin, float deltaMax) {
   
    /* Vector to keep the plane coordinates: */
    vector<float> P;								
    
    /* Assuming the model as a 3D axis-aligned bounding-box: */
    double model_zmax = mesh->vMax.z; 
    double model_zmin = mesh->vMin.z; 
    
    if (delta > 0) { /*Uniform slicing: */

       /* Number of P: */ 
       int no_P = 1 + (int)((model_zmax - model_zmin)/delta);   

       for (size_t i = 0; i < no_P; i++) {	
           /* Building the vector with the slice z coordinates: */
           P.push_back (model_zmin + (float)i * delta);
       }
    }
    else { /*Adaptive slicing: */

       float zplane = 0.0;
       P.push_back (model_zmin + zplane);

       while ((model_zmin + zplane) <= model_zmax) {

          double vrandom = deltaMin + (deltaMax - deltaMin) * (rand() / (double)RAND_MAX);
          double coordinate = model_zmin + zplane + vrandom;
          if (coordinate >= model_zmax) { break; }
          P.push_back (coordinate);
          zplane += vrandom;
       } 
    }
 
    return P;  
}

int checkASCIIFile(const char *fileName)
{
    string line1, line2;
    ifstream input(fileName);
    
    if (!input.good()) return -1;
    
    getline(input, line1);
    getline(input, line2);
    
    //cout << fileName << endl;
    //cout << line1 << endl;
    //cout << line2 << endl;
    //bool solid = regex_match(line1, regex("(solid)(.*)"));
    //bool facet = regex_match(line1, regex("(.*)(facet)(.*)"));
    
    //bool xml = regex_match(line1, regex("(.*)(xml)(.*)"));
    //bool amf = regex_match(line1, regex("(.*)(amf)(.*)"));
    
    //if (regex_match(line1, regex("(.*)(solid)(.*)")) && regex_match(line2, regex("(.*)(facet)(.*)")))
    if (line1.find("solid")!=string::npos && line2.find("facet")!=string::npos)
        return FILE_STL_ASCII;
    //if (regex_match(line1, regex("xml")) && regex_match(line2, regex("amf")))
    if (line1.find("xml")!=string::npos && line2.find("amf")!=string::npos)
        return FILE_AMF_ASCII;
    
    //return (line1.find("solid") && line2.find("facet"));
    return FILE_STL_BIN;
}

// int removeNegativeCoords(const R3_Mesh_t &mesh, R3_Mesh_t *nmesh) {
//     //R3_Mesh_t nmesh;
//     float tx, ty, tz;
//     
//     tx = mesh.vMin.x < 0 ? (-1 * mesh.vMin.x) : 0;
//     ty = mesh.vMin.y < 0 ? (-1 * mesh.vMin.y) : 0;
//     tz = mesh.vMin.z < 0 ? (-1 * mesh.vMin.z) : 0;
//     
//     for (const R3_Triangle_t &t : mesh.mesh) {
//         //R3_Triangle_t nt = t;
//         
//         //for (int p = 0; p < 3;++p) {
//         
//         R3_Triangle_t nt(t.normal,
//                     R3_t(t.v[0].x + tx, t.v[0].y + ty, t.v[0].z + tz),
//                     R3_t(t.v[1].x + tx, t.v[1].y + ty, t.v[1].z + tz),
//                     R3_t(t.v[2].x + tx, t.v[2].y + ty, t.v[2].z + tz)
//                    );
//         //}
//         
//         nmesh->push_back(nt);
//     }
//     
//     return 0;
//     
// }


int main(int argc, char **argv) {

  /* Slicer parameters: */
  float delta = 1.0f;  /* Spacing for uniform slicing (mm) or zero fro adaptive. */
  float deltaMin = 0.016f; /* Min spacing for adaptive slicing (mm). */
  float deltaMax = 0.032f; /* Max spacing for adaptive slicing (mm). */

  /* Slicing algorithm: */
    bool trivialSlicing = true;
    bool sangSlicing = false;
    bool tataSlicing = false;
    bool incrementalSlicing = false;

    /* Loop closure algorithm: */
    bool trivialClosure = true;
    bool loopClosure = false;
    bool bentleyClosure = false;

    /* Model file name: */
    char modelFileName[1024];

    string slicingName = "???";
    string closureName = "???";

    bool sort_triangles = false; /* Sort triangles after reading. */

    bool stats = false;

    for (int i=1; i<argc;) {
        if (0==strcmp(argv[i], "-delta")) {
            delta = atof(argv[i+1]);
            i+=2;
        }
        else if (0==strcmp(argv[i], "-model")) {
            strcpy(modelFileName, argv[i+1]);
            i+=2;
        }
        // else if (0==strcmp(argv[i], "-trivial")) {
        //     slicer = "Trivial";
        //     trivialSlicing = true;
        //     sort_triangles = false;
        //     i+=1;
        // }
        // else if (0==strcmp(argv[i], "-sang")) {
        //     slicer = "Sang";
        //     sang = true;
        //     sort_triangles = false;
        //     i+=1;
        // }
        // else if (0==strcmp(argv[i], "-stolfi")) {
        //     slicer = "Stolfi";
        //     stolfi = true;
        //     sort_triangles = false;
        //     i+=1;
        // }
        // else if (0==strcmp(argv[i], "-huang")) {
        //     slicer = "Huang";
        //     huang = true;
        //     sort_triangles = false;
        //     i+=1;
        //     assert (adaptive == false);
        // }
        else if (0==strcmp(argv[i], "-stats")) {
            stats = true;
            i+=1;
        }
        else {
            ++i;
        }
    }
    
    R3_Mesh_t mesh;
    
    long timeIni = Timer::getTimeMs();
    
    switch (checkASCIIFile(modelFileName)) {
        //  case FILE_AMF_ASCII:
        //      if(0!=amfToMeshInMemory(modelFileName, &mesh))
        //          return 1;
        //      break;
        case FILE_STL_ASCII:
            if (stlToMeshInMemory(modelFileName, &mesh, false)!=0)
                return 1;
            break;
        case FILE_STL_BIN:
            if (stlToMeshInMemory(modelFileName, &mesh, true)!=0)
                return 1;
            break;
        case -1:
            cerr << "File error!!" << endl;
            return 1;
            break;
        default:
            cerr << "Unexpected error" << endl;
            return 1;
            break;
    }

    fprintf(stderr, "Mesh has %d triangles\n", mesh.meshSize);

    // // Optional Model Rotation Around COG Point using GLM Library
    // glm::mat4 mat = glm::mat4(1.0f);
    // glm::fquat quaternion = glm::fquat(DEG_TO_RAD(eulerAngles)); // This glm func wants values as radians
    // float angle = glm::angle(quaternion);
    // glm::highp_fvec3 axis = glm::axis(quaternion);
    // mat = glm::rotate(mat, angle, axis); 
    // mesh.transform(mat);

    // Generate Slices
    // vector<vector<R2_Segment_t> > slicesWithLineSegs;
    
    string path = modelFileName;
    string lastFileName;
    
    size_t pos = path.find_last_of("/");
    if(pos != std::string::npos) { 
      lastFileName.assign(path.begin() + pos + 1, path.end()); 
    } else { 
      lastFileName = path;
    }
    
    struct stat filestatus;
    stat(modelFileName, &filestatus);
    size_t fileSize = filestatus.st_size;
    
    // R3_t aabb = mesh.meshAABBSize();
    
    // if (stats) {
    //     const size_t nSlices = 1+(int)(aabb.z/delta);
    //     double sumTriHeight;
    //     float avgTriHeight;
    //     for (auto t : mesh.mesh) {
    //         sumTriHeight += t.zMax - t.zMin;
    //     }
    //     avgTriHeight = sumTriHeight / mesh.size();
    //     cout << lastFileName << "," << (int)aabb.x << " x " << (int)aabb.y << " x " << (int)aabb.z << "," << mesh.size() << "," << avgTriHeight << "," << (int)(fileSize/1024) << "," << delta << "," << nSlices << endl;
    //     return 0;
    // }

    clock_t slice_begin = clock();

    vector<float> P = compute_P (&mesh, delta, deltaMin, deltaMax);
    fprintf(stderr, "Slicing with %d planes\n", (int)P.size());

    /* The loop closing procedure: */
    // vector<R2_Polygon_t> closer (R3_Mesh_t *mesh, float Z, vector<R2_Segment_t> *segs) {
    // } 

    // !!! Should sort mesh if requested. !!!
    bool srt = mesh.sorted;

    if (trivialSlicing) {
        R3_TrivialSlicing_slice (&mesh, P, NULL);
    } 
    // else if (huang) {
    //     Huang (&mesh, slicesWithLineSegs, delta, P);
    // }
    // else if (sang) {
    //     Sang (&mesh, slicesWithLineSegs, delta, P);
    // }
    else if (incrementalSlicing) {
      R3_IncrementalSlicing_slice (&mesh, P, delta, srt, NULL);
    }

    long slice_end = Timer::getTimeMs();
    timeslice = double(slice_end - slice_begin)/CLOCKS_PER_SEC;

    // long timeEnd = Timer::getTimeMs();
    // 
    // timeTotal = timeEnd - timeIni;
    
    // lock_t contour_begin = clock();
    // lock_t contour_end = clock();
    // imecontour = double(contour_end - contour_begin)/CLOCKS_PER_SEC;
    // 
    // 
    // 
    // lock_t slice_begin = clock();
    // 
    // 
    // clock_t slice_end = clock();
    // timeslice = double(slice_end - slice_begin)/CLOCKS_PER_SEC;
    // 
    // /*Loop-closure:*/
    // clock_t contour_begin = clock();
    // for (size_t p = 0; p < k; p++) {
    //    if (!segs[p].empty()) {
    //       LoopClosureIterative (segs[p], slicesWithLineSegs);
    //    }
    // }
    // clock_t contour_end = clock();
    // timecontour = double(contour_end - contour_begin)/CLOCKS_PER_SEC;
    // 
    // #ifdef USE_OWN
    //    free (vector);
    // #endif
    // 
     return 0;

     // cout << slicer << "," << lastFileName << ",#" << mesh.size() << "," << delta << ",#" << nplanes << "," << visits << "," << intersections << "," << timeBuild << ",@" << timeslice << ",@" << timecontour << "," << timeTotal << ", sort: " << timeSort << ", kbar: " << ((double)intersections/(double)mesh.size()) << endl;
    
   //exportSingleSVGFormat ("out.svg", slicesWithLineSegs, mesh.meshAABBSize());

   //exportSingleSVGFormat3D (slicesWithLineSegs, mesh.meshAABBSize());
   
   //exportSingleSVGFormat4D (slicesWithLineSegs, mesh.meshAABBSize());
   
   return 0;
}

