/* See {image_file_format.h} */
/* Last edited on 2017-06-16 20:46:56 by stolfilocal */

#define _GNU_SOURCE
#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>

#include <bool.h>
#include <argparser.h>

#include <image_file_format.h>

image_file_format_t image_file_format_arg_parse(argparser_t *pp, const char *keyword)
  { argparser_get_keyword(pp, (char *)keyword);
    char *cfmt = argparser_get_next(pp); /* Format argument ("pgm", "JPEG", etc.) */
    image_file_format_t ffmt;  /* Image format code. */
    if ((strcasecmp(cfmt, "jpeg") == 0) || (strcasecmp(cfmt, "jpg") == 0))
      { ffmt = image_file_format_JPG; }
    else if (strcasecmp(cfmt, "png") == 0)
      { ffmt = image_file_format_PNG; }
    else if
      ( (strcasecmp(cfmt, "pnm") == 0) ||
        (strcasecmp(cfmt, "pgm") == 0) ||
        (strcasecmp(cfmt, "ppm") == 0) ||
        (strcasecmp(cfmt, "pbm") == 0)
      )
      { ffmt = image_file_format_PNM; }
    else
      { argparser_error(pp, "unsupported file format"); }
    return ffmt;
  }
  
