/* Last edited on 2007-07-21 13:26:30 by stolfi */

/* ---------------------------------------------------------------------- */
  {
    /* r2x2_moments: */
    throw_matrix(&A);
    r2x2_moments(&A, &a);
    /* Compare with eigenvalues of {A*A^t} by {r2x2_sym_eigen}: */
    r2x2_transp(&A, &B);
    r2x2_mul(&A, &B, &B);
    r2x2_sym_eigen(&B, &b, &C);
    if (verbose)
      { fprintf(stderr, "testing r2x2_moments:\n");
        fprintf(stderr, "A = ");
        r2x2_print(stderr, &A);
        fputc('\n', stderr);
        fprintf(stderr, "moments = ");
        r2_print(stderr, &a);
        fputc('\n', stderr);
        fprintf(stderr, "A*A^t = ");
        r2x2_print(stderr, &B);
        fputc('\n', stderr);
        fprintf(stderr, "eigenvalues = ");
        r2_print(stderr, &b);
        fputc('\n', stderr);
        fputc('\n', stderr);
      }
    double Bmod = B.c[0][0] + B.c[1][1]; 
    for (i = 0; i < N; i++)
      { check_eps(a.c[i], b.c[i], 0.000000001 * Bmod, "r2x2_moments error"); }
  }

/* ---------------------------------------------------------------------- */

#define check_eq(x, y, msg) \
  if ((x) != (y)) \
    { fprintf(stderr, " ** %20.16e %20.16e\n", (x), (y)); \
      affirm(0, msg); \
    } \
  else { }

#define check_eps(x, y, eps, msg) \
  if (fabs((x) - (y)) > (eps)) \
    { fprintf(stderr, " ** %20.16e %20.16e %20.16e\n", (x), (y), (eps)); \
      affirm(0, msg); \
    } \
  else { }

/* ---------------------------------------------------------------------- */

    fprintf(stderr, "a =    "); r2_print(stderr, &a); fputc('\n', stderr);
    fprintf(stderr, "b =    "); r2_print(stderr, &b); fputc('\n', stderr);
    fprintf(stderr, "para = "); r2_print(stderr, &para); fputc('\n', stderr);
    fprintf(stderr, "perp = "); r2_print(stderr, &perp); fputc('\n', stderr);
    fprintf(stderr, "d(pa+pe, a) = %g\n", s);

/* ---------------------------------------------------------------------- */
