// Last edited on 2005-02-14 22:55:28 by stolfi

void test_new_array(desc_t *A, ix_size_t *sz, ix_nbits_t bps, ix_nbits_t bpw)
{
  fprintf(stderr, "Checking num of axes...\n");
  if (ix_NUM_AXES != 5) { bug("unexpected num of axes - fix test"); }
  
  fprintf(stderr, "Checking ix_new_array, ix_valid...\n");
  bool_t verbose = TRUE;
  if (verbose) { ix_print_descriptor(stderr, "A = { ", A, " }\n"); }
  if (! ix_valid(A)) { bug("ix_new_array returns invalid desc"); }
  if (A->base != 0) { bug("base = %u", A->base); }
  if (A->bps != bps) { bug("bpw = %u", A->bps); }
  if (A->bpw != bpw) { bug("bpw = %u", A->bpw); }
  /* Check steps for a vanilla array: */
  ix_tot_size_t stp = 1;
  ix_axis_t ax;
  for (ax = 0; ax < 5; ax++)
    { if (A->step[ax] != stp) { bug("step[%d] = %u", ax, A->step[ax]); }
      stp *= sz[ax];
    }
  
  fprintf(stderr, "Checking ix_inside...\n");
  ix_index_t ixA[ix_NUM_AXES];
  ix_index_clear (ixA);
  if (! ix_inside(A, ixA)) { bug("bogus ix_inside"); }

  for (ax = 0; ax < 5; ax++)
    { ixA[ax] = sz[ax]-1;
      if (! ix_inside(A, ixA)) { bug("bogus ix_inside"); }
      ixA[ax] = sz[ax];
      if (ix_inside(A, ixA)) { bug("bogus ix_inside"); }
      ixA[ax] = 0;
    }
}

void test_packing(desc_t *A)
{
  fprintf(stderr, "Checking ix_set_sample, ix_get_sample on a few elems...\n");
  bool_t verbose = TRUE;
  if (verbose) { ix_print_descriptor(stderr, "A = { ", A, " }\n"); } 
  ix_word_t smask = ((ix_word_t)1 << A->bps) - 1;
  int npos = 5; /* Number of positions to test */
  int ndump = (npos*A->bps + A->bpw - 1)/A->bpw + 1; /* Number of words to dump. */
  fprintf(stderr, "\n");
  ix_pos_t pos;
  for (pos = 0; pos < npos; pos++)
    { ix_sample_t xsmp = (smask & (2*pos)) | 1 | (1<<(A->bps-1));
      if (verbose) { fprintf(stderr, "setting sample %d to %d\n", pos, xsmp); }
      ix_set_sample(A->el, A->bps, A->bpw, pos, xsmp);
      if (verbose) { dump_storage(stderr, A->el, ndump, A->bpw); }
      if (verbose) { fprintf(stderr, "\n"); }
      ix_sample_t smp = ix_get_sample(A->el, A->bps, A->bpw, pos);
      if (smp != xsmp) 
        { bug("set/get sample mismatch smp = %u xsmp = %u", smp, xsmp); } 
    }
  fprintf(stderr, "\n");
}

void dump_storage(FILE *wr, void *el, int nw, ix_nbits_t bpw)
{
  int iw, ib;
  for (iw = 0; iw < nw; iw++)
    { ix_word_t w;
      if (bpw == 8) 
          { w = *(((ix_word_08_t *)el) + iw); }
        else if (bpw == 16) 
          { w = *(((ix_word_16_t *)el) + iw); }
        else 
          { w = *(((ix_word_32_t *)el) + iw); }
      if (iw != 0) { fprintf(wr, " "); }
      for (ib = bpw-1; ib >= 0; ib--)
        { fprintf(wr, "%d", (w >> ib) & 1); }
    }
}

