void xxx_heap_sort_opt(int *h, int n, int cmp(int x, int y), int sgn)
  { /* Arrange elements into a sorted heap, in reverse order: */
    int m = 0, i;
    while (m < n) { shp_heap_insert(h, &m, h[m], cmp, -sgn); }
    fprintf(stderr, "--heap--\n");
    for (i = 0; i < n; i++) { fprintf(stderr, " %4d", h[i]); }
    fprintf(stderr, "\n");
    
    /* Pop them out in reverse order and store them at the end: */
    while (m > 0) { h[m-1] = shp_heap_pop(h, &m, cmp, -sgn); }
    fprintf(stderr, "--paeh--\n");
    for (i = 0; i < n; i++) { fprintf(stderr, " %4d", h[i]); }
    fprintf(stderr, "\n");
  }

======================================================================
/* A buggy mergesort. */

  
/* Threshold for merge-sort->binsertion-sort switch: */
#define TSS_N_MERGE_SMALL 1

void tss_n_merge(int *a, int *b, int *c, int_cmp_t cmp, int sgn)
  {
    auto void tss_n_do_merge(int *ai, int *af, int *bi, int *bf, int **ain, int **bfn);
    /* Merges two consecutive non-empty sorted blocks {A,B}, respectively from
      {*ai} through {*af} and {*bi} through {*bf}, all inclusive. The
      new positions of the elements {*ai} and {*bf} are stored into
      the variables {*ain} and {*bfn}. */

    auto void tss_n_reverse (int *ar, int *br);
    /* Reverses the element block from {*ar} to {*br} (note: both inclusive). */

    auto int *tss_n_block_swap(int *as, int *bs, int *cs); 
    /* Swaps the consecutive blocks {A = *as..*(bs-1)} and {B = *bs..*(cs-1)}.
      Uses the three-flip algorithm.  Returns the boundary between the two 
      blocks after the swap, i.e. the address where {*as} was moved to. */

    void tss_n_reverse (int *ar, int *br)
      { while (ar < br)
          { int t = *ar; *ar = *br; *br = t; ar++; br--; }
      }

    int *tss_n_block_swap (int *as, int *bs, int *cs)
      {
        if (as == bs || bs == cs) return bs;
        fprintf(stderr, "+ swap [%d..%d] [%d..%d]\n", as-a, bs-1-a, bs-a, cs-1-a);
        tss_n_reverse(as, bs-1);
        tss_n_reverse(bs, cs-1);
        tss_n_reverse(as, cs-1);
        fprintf(stderr, "- swap [%d..%d] [%d..%d]\n", as-a, bs-1-a, bs-a, cs-1-a);
        return as + (cs - bs);
      }

   auto void tss_n_do_merge(int *ai, int *af, int *bi, int *bf, int **ain, int **bfn)
      { 
        int *aiv = ai, *bfv = bf;
        affirm((ai <= af) && (bi <= bf), "empty block");
        affirm(bi - af == 1, "block gap");
        fprintf(stderr, "+ merge [%d..%d] [%d..%d]\n", ai-a, af-a, bi-a, bf-a);
        /* Pick a pivot element in each block: */
        int *ap = ai + (bi - ai)/2, *aq = ap-1;
        int *bp = bf - (bf - af)/2, *bq = bp+1;
        fprintf(stderr, "  ap = %d  bp = %d\n", ap-a, bp-a);
        /* Swap {*ap} through {*af} with {*bi} through {*bp}: */
        int *bz = tss_n_block_swap(ap, bi, bq);
        int *az = bz - 1;
        if (aiv==ap) { aiv = bz; }
        if (bfv==bp) { bfv = az; }
        fprintf(stderr, "  az = %d bz = %d  aiv = %d bfv = %d\n", az-a, bz-a, aiv-a, bfv-a);
        /* Compare the pivots, swap if needed: */
        if (sgn*cmp(*az,*bz) >= 0)
          { int t = *az; *az = *bz; *bz = t; 
            if (aiv==az) { aiv = bz; } else if (aiv==bz) { aiv = az; }
            if (bfv==az) { bfv = bz; } else if (bfv==bz) { bfv = az; }
            fprintf(stderr, "  exch %d, %d  aiv = %d bfv = %d\n", az-a, bz-a, aiv-a, bfv-a);
          }
        affirm((aiv==ai) || (aiv==az) || (aiv==bz), "mrg bug");
        affirm((bfv==az) || (bfv==bz) || (bfv==bf), "mrg bug");
        affirm(aiv != bfv, "mrg bug");
        int *aix = ai, *azx = az;
        if (ai < ap) tss_n_do_merge(ai, aq, ap, az, &aix, &azx);
        int *bzx = bz, *bfx = bf;
        if (bp < bf) tss_n_do_merge(bz, bp, bq, bf, &bzx, &bfx);
        if (aiv==ai) { aiv = aix; } else if (aiv==az) { aiv = azx; } else if (aiv==bz) { aiv = bzx; }
        if (bfv==az) { bfv = azx; } else if (bfv==bz) { bfv = bzx; } else if (bfv==bf) { bfv = bfx; }
        fprintf(stderr, "  azx = %d bzx = %d  aiv = %d bfv = %d\n", azx-a, bzx-a, aiv-a, bfv-a);
        /* Merge the tails that may be out of order: */
        if ((azx < az) && (bz < bzx))
          { int *aw, *bw;
            tss_n_do_merge(azx+1, az, bz, bzx-1, &aw, &bw);
          }
        fprintf(stderr, "- merge [%d..%d] [%d..%d] new = %d %d\n", ai-a, af-a, bi-a, bf-a, aiv-a, bfv-a);
        (*ain) = aiv; (*bfn) = bfv;
      }

    int *aw, *bw;
    if ((a < b) && (b < c)) tss_n_do_merge(a, b-1, b, c-1, &aw, &bw);
  }

void tss_n_merge_sort(int *h, int n, int_cmp_t cmp, int sgn)
  {
    auto void tss_n_do_sort(int *a, int *b);
    /* Sorts elements of {h} from {*a} to {*(b-1)} (inclusive). */
  
    void tss_n_do_sort(int *as, int *bs)
      { int nab = bs - as;
        if (nab <= TSS_N_MERGE_SMALL) 
          { isrt_binssort(as, nab, cmp, sgn); }
        else
          { int *ms = as + nab/2;
            tss_n_do_sort (as, ms);
            tss_n_do_sort (ms, bs);
            tss_n_merge(as, ms, bs, cmp, sgn);
          }
      }

    (void) tss_n_do_sort(h, h+n);
  }
======================================================================
======================================================================
