/* See {salamic_slicer.h}. */
/* Last edited on 2015-10-09 22:01:39 by stolfilocal */

#define _GNU_SOURCE
#include <stdio.h>
#include <stdint.h>
#include <string.h>
#include <assert.h>
#include <stdlib.h>

#include <bool.h>
#include <vec.h>
#include <affirm.h>

#include <stmesh.h>
#include <salamic_stats.h>

#include <salamic_slicer.h>
#include <salamic_slicer_trivial.h>
#include <salamic_slicer_Minetto.h>
/* #include <salamic_slicer_Sang.h> */
/* #include <salamic_slicer_Tata.h> */

void salamic_slicer_slice
  ( stmesh_t mesh,
    bool_t preSorted, 
    int_vec_t *planeZ, 
    bool_t uniform,
    char *slicer, 
    char *closer, 
    char *outPrefix, 
    salamic_stats_t *st
  )
  {
    if (strcmp(slicer, "TRIVIAL") == 0)
      { salamic_slicer_trivial_slice(mesh, planeZ, closer, outPrefix, st); }
    else if (strcmp(slicer, "MINETTO") == 0)
      { salamic_slicer_Minetto_slice(mesh, preSorted, planeZ, uniform, closer, outPrefix, st); }
    /*
    else if (strcmp(slicer, "SANG") == 0)
      { demand(uniform, "Sang's algorithm requires uniform slice spacing");
        salamic_slicer_Sang_slice(mesh, planeZ, closer, outPrefix, st);
      }
    else if (strcmp(slicer, "TATA") == 0)
      { salamic_slicer_Tata_slice(mesh, preSorted, planeZ, uniform, closer, outPrefix, st);
      }
    */
    else 
      { demand(FALSE, "unknown or unimplemented slicing algorithm"); }
  }
