/* Stolfi's loop closure of segments defined by 2 edges + plane */
/* Last edited on 2015-11-16 00:19:25 by stolfilocal */

#ifndef salamic_closer_Stolfi_H
#define salamic_closer_Stolfi_H

#define _GNU_SOURCE
#include <stdio.h>
#include <stdint.h>

#include <bool.h>

#include <stmesh.h>
#include <salamic_closer.h>
#include <salamic_stats.h>

void salamic_closer_Stolfi_close
  ( stmesh_t mesh,
    int32_t pZ,
    uint32_t mf,
    stmesh_face_t f[], 
    uint32_t *ncP,
    uint32_t estart[],
    stmesh_edge_t e[],
    salamic_stats_t *st
  );
  /* Loop closure by the Stolfi algorithm (uses edge indices to match
    segments). 
    
    The program first builds, for each edge {e} that crosses the slicing plane,
    a linked list of all the faces that share that edge.  Then, as each 
    face gets used by the closer, it is removed from the 
    corresponding lists.
    
    The section is returned in the arrays {e} (that must have at least {2*mf}
    elements) and {estart} (that must have at least {mf+1} elements).
    The number {nc} of paths found is returned in {*ncP}. 
    
    Specifically, the edges that define the vertices of path {k} will be
    stored in {e[ak..bk-1]}, where {ak = estart[k]} and {bk =
    estart[k+1]}. The path is closed if an only if {e[ak] = e[bk-1]}.
    The total number of vertices in all paths is {me = estart[nc]}.
    
    See {salamic_closer.h} for
    preconditions and for the meaning of the other parameters. */

#endif
