/* Trivial loop closure of segments defined by 2 points of {R 2} */
/* Last edited on 2015-11-16 00:19:58 by stolfilocal */

#ifndef salamic_closer_trivial_H
#define salamic_closer_trivial_H

#define _GNU_SOURCE
#include <stdio.h>
#include <stdint.h>

#include <bool.h>

#include <stmesh.h>
#include <salamic_closer.h>
#include <salamic_stats.h>

void salamic_closer_trivial_close
  ( stmesh_t mesh,
    int32_t pZ,
    uint32_t mf,
    stmesh_face_t f[], 
    uint32_t *ncP,
    uint32_t estart[],
    stmesh_edge_t e[],
    salamic_stats_t *st
  );
  /* Loop closure by the trivial algorithm (exhaustive search for
    matching endpoints).
    
    The section is returned in the arrays {e} (that must have at least {2*mf}
    elements) and {estart} (that must have at least {mf+1} elements).
    The number {nc} of paths found is returned in {*ncP}. 
    
    Specifically, the edges that define the vertices of path {k} will be
    stored in {e[ak..bk-1]}, where {ak = estart[k]} and {bk =
    estart[k+1]}. The path is closed if an only if {e[ak] = e[bk-1]}.
    The total number of vertices in all paths is {me = estart[nc]}. 
    
    Writes the contours to file {wr}. See {salamic_closer.h} for
    preconditions and for the meaning of the other parameters. */

#endif
